package com.ovopark.iohub.sdk.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

//messagehub-node
@Data
public class ClientNodeRegisterRequest implements Model {

    private int version;

    private int minVersion;

    private String app;

    private String node;

    private String ip;

    private int port;

    private String servletPath;

    private String nfsPath;

    private String nodeRootPath;

    private String nfsCheckContent;

    private String tsFilePath;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private LocalDateTime startupTime;

    private List<TaskModel> exportTaskModelList;

    private List<TaskModel> importTaskModelList;


    private List<RenderTaskModel> renderTaskModelList;

}
