package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.ByteSize;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.sequencefile.SequenceFile;
import com.ovopark.kernel.shared.sequencefile.SequenceFileImpl;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class SegmentFileReader implements Closeable {

    private final SequenceFile sequenceFile;

    public SegmentFileReader(String path) {
        this(path, ByteSize.gb);
    }

    public SegmentFileReader(String path, long size) {
        this.sequenceFile=new SequenceFileImpl("segment", path, size);
    }


    public final synchronized void scan(RowDataListener rowDataListener) throws IOException {
        sequenceFile.scan(new SequenceFile.SequenceRowListener() {
            @Override
            public void onRow(byte[] bytes, int i, int i1) {
                String c = new String(bytes, i, i1, StandardCharsets.UTF_8);
                Segment.RowRegion rowRegion = JSONAccessor.impl().read(c, Segment.RowRegion.class);
                for (Map<String, Object> row : rowRegion.getDataList()) {
                    rowDataListener.onRow(row);
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        sequenceFile.close();
    }

    public interface RowDataListener {

        void onRow(Map<String,Object> row);

    }

}
