package com.ovopark.iohub.sdk.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class AppNode implements Model {

    private int version;

    private int minVersion;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private LocalDateTime startupTime;

    private String app;

    private String node;

    private String ip;

    private int port;

    private String servletPath;

    private String nfsPath;

    private String nodeRootPath;

    private String nfsCheckContent;

    /**
     * @since 1.27
     */
    private boolean nfsActive;

    /**
     * @since 2.3
     */
    private String tsFilePath;

    /**
     * @since 2.3
     */
    private boolean tsActive;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private LocalDateTime time;

    private int receivedImportCount;

    private int receivedExportCount;

    private ExportWorkPool exportWorkPool;

    private ImportWorkPool importWorkPool;

    private List<TaskModel> exportTaskModelList;

    private List<RenderTaskModel> renderTaskModelList;

    private List<TaskModel> importTaskModelList;

}
