package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class ReplyRowModel implements Model {

    private int segment;

    private int fromRow;

    private int toRow;

    private List<String> descList=new ArrayList<>();

    public static ReplyRowModel replyWithSegment(int segment, int fromRow, int toRow, String desc) {
        ReplyRowModel replyModel = new ReplyRowModel();
        replyModel.setSegment(segment);
        replyModel.setFromRow(fromRow);
        replyModel.setToRow(toRow);
        replyModel.getDescList().add(desc);
        return replyModel;
    }

    public static ReplyRowModel replyWithSegment(int segment, int row, String desc) {
        return replyWithSegment(segment, row, row, desc);
    }

    public static ReplyRowModel reply(int row, String desc) {
        return replyWithSegment(0, row, desc);
    }

    public static ReplyRowModel reply(int fromRow, int toRow, String desc) {
        return replyWithSegment(0, fromRow, toRow, desc);
    }

}
