package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@Data
public class ReplyModel implements Model {

    private int successCount;

    private int errorCount;

    private int repeatCount;

    private int status;

    private String failMsg;

    private Map<Integer, List<ReplyRowModel>> replyMap=new ConcurrentHashMap<>();

    public void add(ReplyRowModel replyRowModel){
        replyMap.computeIfAbsent(replyRowModel.getSegment(), new Function<Integer, List<ReplyRowModel>>() {
            @Override
            public List<ReplyRowModel> apply(Integer integer) {
                return new ArrayList<>();
            }
        }).add(replyRowModel);
    }

}
