package com.ovopark.iohub.sdk.model.proto;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Data
public class SegmentImpl implements Segment{

    private String name;

    private HeaderImpl header=new HeaderImpl();

    private TitleImpl title=new TitleImpl();

    private List<Map<String,Object>> rowList;

    private Map<String,Object> meta;

    private String group;

    private Feature feature=new Feature();

    private SegmentRuntimeStatImpl segmentRuntimeStat=new SegmentRuntimeStatImpl();

    public SegmentImpl(String name,int size,String group) {
        this.name=name;
        this.rowList = new ArrayList<>(size);
        this.group=group;
    }

    @Override
    public List<Map<String,Object>> rowList() {
        return rowList;
    }

    @Override
    public int size() {
        return rowList.size();
    }

    @Override
    public synchronized void append(Map<String,Object> row) {
        rowList.add(row);
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public Header header() {
        return header;
    }

    @Override
    public Title title() {
        return title;
    }

    @Override
    public Map<String, Object> meta() {
        return meta;
    }

    @Override
    public String group() {
        return group;
    }

    @Override
    public void commit() {

    }

    @Override
    public Feature feature() {
        return feature;
    }

    @Override
    public SegmentRuntimeStat segmentRuntimeStat() {
        return segmentRuntimeStat;
    }
}
