/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.iohub.sdk.model.proto.CellFile;
import com.ovopark.iohub.sdk.model.proto.HeaderCellImpl;
import com.ovopark.iohub.sdk.model.proto.HeaderImpl;
import com.ovopark.iohub.sdk.model.proto.LimitLogger;
import com.ovopark.iohub.sdk.model.proto.MixedRowTransLogImpl;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.RowTransLog;
import com.ovopark.iohub.sdk.model.proto.RowTransLogConfig;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.iohub.sdk.model.proto.TitleImpl;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.sequencefile.FileIO;
import com.ovopark.kernel.shared.sequencefile.SimpleFileIO;
import com.ovopark.kernel.shared.sequencefile.TransLogConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;

public class NFSOutStore
implements OutStore,
LimitLogger.LimitLoggerSetter {
    private String fileName;
    private final String path;
    private final List<SegmentFileDescriptor> segmentFileDescriptorList;
    private boolean committed;
    private final List<SegmentFileWriter> segmentFileWriterList = new ArrayList<SegmentFileWriter>();
    private final FileIO fileIO;
    private final String fileIOUrl;
    private final Map<String, OutStore.Group> groupMap = new HashMap<String, OutStore.Group>();
    private final RowTransLogConfig rowTransLogConfig;
    final OutStore.Stat stat = new OutStore.Stat();
    final OutStore.RuntimeStat runtimeStat = new OutStore.RuntimeStatImpl();
    private final OutStore.Feature feature = new OutStore.Feature();
    LimitLogger limitLogger;

    public NFSOutStore(String path, int size) {
        this(path, size, null);
    }

    public NFSOutStore(String path, int size, RowTransLogConfig rowTransLogConfig) {
        this.path = path + "/" + Util.uniqueFirstPart();
        File file = new File(this.path);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.segmentFileDescriptorList = new ArrayList<SegmentFileDescriptor>(size);
        this.rowTransLogConfig = rowTransLogConfig == null ? new RowTransLogConfig() : rowTransLogConfig;
        TransLogConfig transLogConfig = new TransLogConfig();
        this.fileIOUrl = this.path + "/" + Util.uniqueFirstPart() + "-file.bf";
        this.fileIO = new SimpleFileIO("nfs", this.fileIOUrl, transLogConfig, false);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name) {
        return this.createSegment(name, 1);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, int rowSize) {
        return this.createSegment(name, rowSize, "default");
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, String group) {
        return this.createSegment(name, 1, group);
    }

    @Override
    public OutStore.SegmentWriter createSegment(String name, int rowSize, String group) {
        this.check();
        if (this.segmentFileWriterList.size() > 256) {
            throw new IllegalArgumentException("exceed max segment size 256 ");
        }
        SegmentFileWriter segmentFileWriter = new SegmentFileWriter(name, group, rowSize);
        this.segmentFileWriterList.add(segmentFileWriter);
        this.groupMap.putIfAbsent(group, new OutStore.Group());
        this.runtimeStat.segmentAdd(group + ":" + name);
        this.runtimeStat.segmentCountAdd(1);
        this.limitLogger.log("create segment " + group + ":" + name);
        return segmentFileWriter;
    }

    @Override
    public synchronized OutStore.SegmentWriter cloneSegmentExcludeRowData(String name, String target) {
        SegmentFileWriter sf = null;
        for (SegmentFileWriter segmentFileWriter : this.segmentFileWriterList) {
            if (!segmentFileWriter.name.equals(name)) continue;
            sf = segmentFileWriter;
            break;
        }
        if (sf == null) {
            throw new IllegalArgumentException("cannot find segment: " + name);
        }
        SegmentFileWriter segmentFileWriter = new SegmentFileWriter(target, sf.group, sf.rowCount);
        final Segment.Header targetHeader = segmentFileWriter.header();
        sf.header.scanUp2Down(new Segment.Header.Scan(){

            @Override
            public void scan(Segment.Header.Cell cell) {
                String p = cell.path();
                if (p.contains(".")) {
                    targetHeader.upset(p.substring(0, p.lastIndexOf(".")), p.substring(p.lastIndexOf(".")), null);
                } else {
                    targetHeader.upset(null, p, null);
                }
                HeaderCellImpl c = (HeaderCellImpl)cell;
                HeaderCellImpl targetCell = (HeaderCellImpl)targetHeader.cell(p);
                targetCell.setWidth(c.getWidth());
                targetCell.setI18Key(c.getI18Key());
                targetCell.setName(c.getName());
                targetCell.setTip(c.getTip());
                targetCell.setVirtual(c.isVirtual());
                Segment.HeaderFeature feature1 = c.feature();
                if (feature1 != null) {
                    Segment.HeaderFeature headerFeature = feature1.clone();
                    targetCell.setHeaderFeature(headerFeature);
                }
            }
        });
        segmentFileWriter.title().title(sf.title().title());
        return segmentFileWriter;
    }

    @Override
    public void commit() {
        this.committed = true;
    }

    @Override
    public void close() {
        Exception exception = null;
        for (SegmentFileWriter segmentFileWriter : this.segmentFileWriterList) {
            try {
                segmentFileWriter.close();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        try {
            this.fileIO.close();
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            throw Util.convert2RuntimeException((Throwable)exception);
        }
    }

    private void check() {
        if (this.committed) {
            throw new UnsupportedOperationException("all committed???");
        }
    }

    @Override
    public Segment segment(Segment.SD sd) {
        for (final SegmentFileDescriptor segmentFileDescriptor : this.segmentFileDescriptorList) {
            if (!segmentFileDescriptor.getName().equals(sd.getName()) || !segmentFileDescriptor.getGroup().equals(sd.getGroup())) continue;
            return new Segment(){

                @Override
                public List<Map<String, Object>> rowList() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int size() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void append(Map<String, Object> row) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String name() {
                    return segmentFileDescriptor.getName();
                }

                @Override
                public Map<String, Object> meta() {
                    return segmentFileDescriptor.getMeta();
                }

                @Override
                public Segment.Title title() {
                    return segmentFileDescriptor.title;
                }

                @Override
                public Segment.Header header() {
                    return segmentFileDescriptor.header;
                }

                @Override
                public String group() {
                    return segmentFileDescriptor.getGroup();
                }

                @Override
                public void commit() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Segment.Feature feature() {
                    return segmentFileDescriptor.getFeature();
                }
            };
        }
        return null;
    }

    @Override
    public List<Segment.SD> sdList() {
        ArrayList<Segment.SD> sdList = new ArrayList<Segment.SD>(this.segmentFileDescriptorList.size());
        for (SegmentFileDescriptor segmentFileDescriptor : this.segmentFileDescriptorList) {
            Segment.SD sd = new Segment.SD();
            sd.setName(segmentFileDescriptor.getName());
            sd.setMemory(false);
            sd.setUrl(segmentFileDescriptor.getPath());
            sd.setRowCount(segmentFileDescriptor.getRowCount());
            sd.setGroup(segmentFileDescriptor.getGroup());
            sdList.add(sd);
        }
        return sdList;
    }

    @Override
    public CellFile file(byte[] data, String name, String type) {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("name", name);
        meta.put("type", type);
        FileIO.FilePutResult filePutResult = this.fileIO.put(meta, data);
        CellFile cellFile = new CellFile();
        cellFile.setName(name);
        cellFile.setType(type);
        cellFile.setBase64(false);
        cellFile.setUri(filePutResult.seq());
        return cellFile;
    }

    @Override
    public LimitLogger limitLogger() {
        return this.limitLogger;
    }

    @Override
    public void fileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public OutStore.GroupOperation group(final String group) {
        return new OutStore.GroupOperation(){

            @Override
            public void fileName(String fileName) {
                ((OutStore.Group)NFSOutStore.this.groupMap.get(group)).setFileName(fileName);
            }
        };
    }

    @Override
    public OutStore.FeatureOperation feature() {
        return new OutStore.FeatureOperation(){

            @Override
            public void supportRangeMerge(boolean rangeMerge) {
                NFSOutStore.this.feature.setRangeMerge(rangeMerge);
            }

            @Override
            public void supportBorder(boolean border) {
                NFSOutStore.this.feature.setBorder(border);
            }
        };
    }

    @Override
    public OutStore.Stat stat() {
        return this.stat;
    }

    @Override
    public OutStore.RuntimeStat runtimeStat() {
        return this.runtimeStat;
    }

    @Override
    public void setLimitLogger(LimitLogger limitLogger) {
        this.limitLogger = limitLogger;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileIOUrl() {
        return this.fileIOUrl;
    }

    public Map<String, OutStore.Group> getGroupMap() {
        return this.groupMap;
    }

    public OutStore.Feature getFeature() {
        return this.feature;
    }

    class SegmentFileWriter
    implements OutStore.SegmentWriter {
        static final int maxCount = 1048000;
        private final String name;
        private final String group;
        private final RowTransLog rowTransLog;
        final String filePath;
        private final Segment.Header header = new HeaderImpl();
        private final Segment.Title title = new TitleImpl();
        private Map<String, Object> meta;
        private int rowCount;
        private boolean committed;
        private boolean closed;
        private final OutStore.SegmentStat segmentStat = new OutStore.SegmentStat();
        private final Segment.Feature segmentFeature = new Segment.Feature();

        public SegmentFileWriter(String name, String group, int size) {
            this.name = name;
            this.group = group;
            this.filePath = NFSOutStore.this.path + "/" + Util.md5((String)(group + ":" + name));
            this.rowTransLog = new MixedRowTransLogImpl("segment", this.filePath, NFSOutStore.this.rowTransLogConfig);
        }

        @Override
        public synchronized void append(Map<String, Object> data) {
            if (NFSOutStore.this.runtimeStat.cancelled()) {
                throw new CancellationException("task is cancelled");
            }
            this.rowTransLog.append(data);
            ++this.rowCount;
            NFSOutStore.this.runtimeStat.rowCountAdd(1);
            NFSOutStore.this.runtimeStat.lastIoTimeMs(System.currentTimeMillis());
            NFSOutStore.this.runtimeStat.byteSize(this.rowTransLog.byteSize());
            if (this.rowCount > 1048000) {
                throw new IllegalArgumentException("exceed max row count: 1048000 / 1048576 ???");
            }
        }

        @Override
        public synchronized void append(List<Map<String, Object>> data) {
            if (NFSOutStore.this.runtimeStat.cancelled()) {
                throw new CancellationException("task is cancelled");
            }
            this.rowTransLog.append(data);
            this.rowCount += data.size();
            NFSOutStore.this.runtimeStat.rowCountAdd(data.size());
            NFSOutStore.this.runtimeStat.lastIoTimeMs(System.currentTimeMillis());
            NFSOutStore.this.runtimeStat.byteSize(this.rowTransLog.byteSize());
            if (this.rowCount > 1048000) {
                throw new IllegalArgumentException("exceed max row count: 1048000 / 1048576 ???");
            }
        }

        @Override
        public synchronized void append(Model model) {
            this.append(JSONAccessor.impl().read(JSONAccessor.impl().format((Object)model)));
        }

        @Override
        public void meta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Override
        public synchronized void commit() {
            if (this.committed) {
                return;
            }
            this.rowTransLog.fsync();
            long l = this.rowTransLog.byteSize();
            NFSOutStore.this.runtimeStat.byteSize(l);
            for (SegmentFileDescriptor segmentFileDescriptor : NFSOutStore.this.segmentFileDescriptorList) {
                if (!segmentFileDescriptor.getPath().equalsIgnoreCase(this.filePath)) continue;
                throw new IllegalArgumentException("file is duplicate: " + this.filePath);
            }
            SegmentFileDescriptor segmentFileDescriptor = new SegmentFileDescriptor();
            segmentFileDescriptor.setPath(this.filePath);
            segmentFileDescriptor.setName(this.name);
            segmentFileDescriptor.setTitle(this.title);
            segmentFileDescriptor.setHeader(this.header);
            segmentFileDescriptor.setMeta(this.meta);
            segmentFileDescriptor.setGroup(this.group);
            segmentFileDescriptor.setRowCount(this.rowCount);
            segmentFileDescriptor.setFeature(this.segmentFeature);
            NFSOutStore.this.segmentFileDescriptorList.add(segmentFileDescriptor);
            this.header().commit();
            this.segmentStat.setRowCount(this.rowCount);
            if (NFSOutStore.this.stat.getSegmentStatList() == null) {
                NFSOutStore.this.stat.setSegmentStatList(new ArrayList<OutStore.SegmentStat>());
            }
            NFSOutStore.this.stat.getSegmentStatList().add(this.segmentStat);
            this.committed = true;
            try {
                Util.log.info("committed , close segment: " + this.name);
                this.rowTransLog.close();
                this.closed = true;
            }
            catch (IOException e) {
                throw Util.convert2RuntimeException((Throwable)e);
            }
        }

        @Override
        public Segment.Header header() {
            return this.header;
        }

        @Override
        public Segment.Title title() {
            return this.title;
        }

        @Override
        public String group() {
            return this.group;
        }

        void close() throws Exception {
            if (this.closed) {
                return;
            }
            this.rowTransLog.close();
        }

        @Override
        public OutStore.SegmentWriter.FeatureOperation feature() {
            return new OutStore.SegmentWriter.FeatureOperation(){

                @Override
                public void supportRangeMerge(boolean rangeMerge) {
                    SegmentFileWriter.this.segmentFeature.setRangeMerge(rangeMerge);
                }

                @Override
                public void supportBorder(boolean border) {
                    SegmentFileWriter.this.segmentFeature.setBorder(border);
                }
            };
        }
    }

    static class SegmentFileDescriptor
    implements Model {
        private String path;
        private String name;
        private Segment.Title title;
        private Segment.Header header;
        private Map<String, Object> meta;
        private String group;
        private int rowCount;
        private Segment.Feature feature;

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public Segment.Title getTitle() {
            return this.title;
        }

        public Segment.Header getHeader() {
            return this.header;
        }

        public Map<String, Object> getMeta() {
            return this.meta;
        }

        public String getGroup() {
            return this.group;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public Segment.Feature getFeature() {
            return this.feature;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTitle(Segment.Title title) {
            this.title = title;
        }

        public void setHeader(Segment.Header header) {
            this.header = header;
        }

        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        public void setFeature(Segment.Feature feature) {
            this.feature = feature;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentFileDescriptor)) {
                return false;
            }
            SegmentFileDescriptor other = (SegmentFileDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRowCount() != other.getRowCount()) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Segment.Title this$title = this.getTitle();
            Segment.Title other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            Segment.Header this$header = this.getHeader();
            Segment.Header other$header = other.getHeader();
            if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            Segment.Feature this$feature = this.getFeature();
            Segment.Feature other$feature = other.getFeature();
            return !(this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SegmentFileDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRowCount();
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Segment.Title $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            Segment.Header $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            Segment.Feature $feature = this.getFeature();
            result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
            return result;
        }

        public String toString() {
            return "NFSOutStore.SegmentFileDescriptor(path=" + this.getPath() + ", name=" + this.getName() + ", title=" + this.getTitle() + ", header=" + this.getHeader() + ", meta=" + this.getMeta() + ", group=" + this.getGroup() + ", rowCount=" + this.getRowCount() + ", feature=" + this.getFeature() + ")";
        }
    }
}

