/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.iohub.sdk.model.proto;

import com.ovopark.iohub.sdk.model.proto.CellDataType;
import com.ovopark.iohub.sdk.model.proto.CellDef;
import com.ovopark.iohub.sdk.model.proto.CellValue;
import com.ovopark.iohub.sdk.model.proto.CellVirtual;
import com.ovopark.iohub.sdk.model.proto.ExcludeInHeader;
import com.ovopark.iohub.sdk.model.proto.FontDef;
import com.ovopark.iohub.sdk.model.proto.HeaderCellImpl;
import com.ovopark.iohub.sdk.model.proto.HeaderDef;
import com.ovopark.iohub.sdk.model.proto.HyperlinkDef;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class HeaderImpl
implements Segment.Header,
Model {
    private boolean committed;
    private boolean fixed;
    private final List<HeaderCellImpl> cellList = new ArrayList<HeaderCellImpl>();
    private int height;
    private int defaultColumnWidth = 15;
    private int maxHeadIndex;
    private int maxPossibleHeadIndex;
    private int deltaY;

    @Override
    public int maxHeadIndex() {
        return this.maxHeadIndex;
    }

    @Override
    public void maxPossibleHeadIndex(int maxPossibleHeadIndex) {
        this.maxPossibleHeadIndex = maxPossibleHeadIndex;
    }

    @Override
    public int maxPossibleHeadIndex() {
        return this.maxPossibleHeadIndex;
    }

    @Override
    public Segment.HeaderFeatureOperation root(String property) {
        if (this.committed) {
            throw new IllegalArgumentException("header was fixed, cannot modify");
        }
        return this.upset(null, property, null, null);
    }

    @Override
    public void root(List<String> propertyList) {
        if (this.committed) {
            throw new IllegalArgumentException("header was fixed, cannot modify");
        }
        propertyList.forEach(this::root);
    }

    @Override
    public void i18n(Segment.Header.I18n i18n) {
        this.func(i18n::i18n, this.cellList, (s, cell) -> cell.setName((String)s), headerCell -> Util.isNotEmpty((CharSequence)headerCell.getI18Key()) ? headerCell.getI18Key() : headerCell.getPath(), cell -> Util.isEmpty((CharSequence)cell.getName()));
    }

    @Override
    public void width(Segment.Header.Width width) {
        this.func(width::width, this.cellList, (s, cell) -> cell.setWidth((int)s), null, cell -> true);
    }

    @Override
    public Segment.Header.Cell cell(String path) {
        String[] pathList = path.split("\\.");
        List<HeaderCellImpl> searchList = this.cellList;
        Segment.Header.Cell mayMatchCell = null;
        for (int i = 0; i < pathList.length; ++i) {
            String matchProperty = pathList[i];
            if (Util.isEmpty(searchList)) {
                return null;
            }
            boolean found = false;
            for (HeaderCellImpl headerCell : searchList) {
                if (!matchProperty.equals(headerCell.getProperty())) continue;
                searchList = headerCell.getCellList();
                found = true;
                mayMatchCell = headerCell;
                break;
            }
            if (found) continue;
            return null;
        }
        return mayMatchCell != null ? (path.equals(mayMatchCell.path()) ? mayMatchCell : null) : null;
    }

    @Override
    public boolean delete(String path, String property) {
        List<HeaderCellImpl> foundCellList;
        if (this.committed) {
            throw new IllegalArgumentException("header was fixed, cannot modify");
        }
        if (Util.isEmpty((CharSequence)path)) {
            foundCellList = this.cellList;
        } else {
            Segment.Header.Cell cell = this.cell(path);
            if (cell == null) {
                return false;
            }
            HeaderCellImpl headerCell = (HeaderCellImpl)cell;
            foundCellList = headerCell.getCellList();
        }
        if (Util.isEmpty(foundCellList)) {
            return false;
        }
        return foundCellList.removeIf(c -> {
            boolean f = c.property().equals(property);
            Util.log.info("delete header: " + c.path());
            return f;
        });
    }

    @Override
    public void printPretty() {
        this.printPretty(System.out);
    }

    @Override
    public void printPretty(final OutputStream outputStream) {
        try {
            outputStream.write(Util.utf8((String)"================================heard def start========================\r\n"));
            this.scanUp2Down(new Segment.Header.Scan(){

                @Override
                public void scan(Segment.Header.Cell cell) {
                    HeaderCellImpl headerCell = (HeaderCellImpl)cell;
                    try {
                        outputStream.write(Util.utf8((String)(headerCell.getI18Key() + "=" + headerCell.getTip() + "\r\n")));
                    }
                    catch (IOException e) {
                        throw Util.convert2RuntimeException((Throwable)e);
                    }
                }
            });
            outputStream.write(Util.utf8((String)"================================heard def end========================\r\n"));
        }
        catch (Exception e) {
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    private <R> void func(Function<String, R> func, List<HeaderCellImpl> cellList, CellFuncSet<R> cellFuncSet, Function<HeaderCellImpl, String> pathGet, Predicate<HeaderCellImpl> cellPredicate) {
        for (HeaderCellImpl cell : cellList) {
            if (!cellPredicate.test(cell)) continue;
            R apply = func.apply(pathGet == null ? cell.getPath() : pathGet.apply(cell));
            cellFuncSet.set(apply, cell);
            if (!Util.isNotEmpty(cell.getCellList())) continue;
            this.func(func, cell.getCellList(), cellFuncSet, pathGet, cellPredicate);
        }
    }

    @Override
    public void children(String path, List<String> propertyList) {
        for (String p : propertyList) {
            this.upset(path, p, null, null);
        }
    }

    @Override
    public Segment.HeaderFeatureOperation children(String path, String property) {
        return this.children(path, property, null);
    }

    @Override
    public Segment.HeaderFeatureOperation children(String path, String property, Segment.Header.Width width) {
        return this.children(path, property, width, null);
    }

    @Override
    public Segment.HeaderFeatureOperation children(String path, String property, Segment.Header.Width width, Segment.Header.I18n i18n) {
        return this.children(path, property, width, i18n, null);
    }

    @Override
    public Segment.HeaderFeatureOperation children(String path, String property, Segment.Header.Width width, Segment.Header.I18n i18n, Segment.Header.CellType cellType) {
        return this.upset(path, property, width, i18n, cellType);
    }

    @Override
    public Segment.HeaderFeatureOperation upset(String path, String property, Segment.Header.Width width) {
        return this.upset(path, property, width, null);
    }

    @Override
    public Segment.HeaderFeatureOperation upset(String path, String property, Segment.Header.Width width, Segment.Header.I18n i18n) {
        return this.upset(path, property, width, i18n, null);
    }

    @Override
    public Segment.HeaderFeatureOperation upset(String path, String property, Segment.Header.Width width, Segment.Header.I18n i18n, Segment.Header.CellType cellType) {
        return this.upset0(path, property, width, i18n, cellType, c -> {}, false);
    }

    @Override
    public void upsetAsVirtual(String path, String property) {
        this.upset0(path, property, a -> 30, b -> null, c -> CellDataType.NONE, d -> {}, true);
    }

    @Override
    public void updateAsVirtual(String path) {
        Segment.Header.Cell cell = this.cell(path);
        ((HeaderCellImpl)cell).setVirtual(true);
    }

    private Segment.HeaderFeatureOperation upset0(String path, String property, Segment.Header.Width width, Segment.Header.I18n i18n, Segment.Header.CellType cellType, Consumer<HeaderCellImpl> headerCellConsumer, boolean virtual) {
        Segment.Header.Cell c;
        if (this.committed) {
            throw new IllegalArgumentException("header was fixed, cannot modify");
        }
        if (Util.isEmpty((CharSequence)path)) {
            Segment.Header.Cell c2 = this.cell(property);
            HeaderCellImpl cell = c2 == null ? new HeaderCellImpl() : (HeaderCellImpl)c2;
            cell.setProperty(property);
            cell.setLevel(0);
            cell.setExcelY(0);
            cell.setPath(property);
            if (width != null) {
                cell.setWidth(width.width(property));
            }
            if (i18n != null) {
                cell.setName(i18n.i18n(property));
            }
            if (cellType != null) {
                cell.setCellType(cellType.cellType(property));
            }
            cell.setVirtual(virtual);
            headerCellConsumer.accept(cell);
            if (c2 == null) {
                this.cellList.add(cell);
            }
            return new HeaderFeatureOperationImpl(cell);
        }
        HeaderCellImpl pathCell = null;
        List<HeaderCellImpl> queryCellList = this.cellList;
        String[] pl = path.split("\\.");
        for (int i = 0; i < pl.length; ++i) {
            String p = pl[i];
            HeaderCellImpl next = null;
            for (HeaderCellImpl cell : queryCellList) {
                if (!cell.getProperty().equals(p)) continue;
                next = cell;
                break;
            }
            if (next == null) {
                throw new IllegalArgumentException("sub path: '" + p + "' is missing? " + path);
            }
            queryCellList = next.getCellList();
            pathCell = next;
        }
        if (pathCell == null) {
            throw new IllegalArgumentException("path is missing: " + path);
        }
        List<HeaderCellImpl> cellList = pathCell.getCellList();
        if (cellList == null) {
            cellList = new ArrayList<HeaderCellImpl>();
        }
        HeaderCellImpl cell = (c = this.cell(path + "." + property)) == null ? new HeaderCellImpl() : (HeaderCellImpl)c;
        cell.setProperty(property);
        cell.setPath(path + "." + property);
        cell.setLevel(pl.length);
        cell.setExcelY(pl.length);
        if (width != null) {
            cell.setWidth(width.width(cell.getPath()));
        }
        if (i18n != null) {
            cell.setName(i18n.i18n(cell.getPath()));
        }
        if (cellType != null) {
            cell.setCellType(cellType.cellType(cell.getPath()));
        }
        cell.setVirtual(virtual);
        headerCellConsumer.accept(cell);
        this.height = Math.max(this.height, cell.getLevel());
        if (c == null) {
            cellList.add(cell);
        }
        pathCell.setCellList(cellList);
        return new HeaderFeatureOperationImpl(cell);
    }

    @Override
    public void defaultColumnWidth(int width) {
        this.defaultColumnWidth = width;
    }

    @Override
    public int defaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    @Override
    public void all(Class<? extends Model> clazz) {
        this.all(clazz, a -> null);
    }

    private void extendField(String path, Field field, Map<String, Field> fieldMap, boolean include) {
        if (field.getGenericType() instanceof ParameterizedType) {
            if (!include) {
                fieldMap.put(path, field);
            }
            Type actualTypeArgument = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            Map tmpFieldMap = Util.flatProperty((Class)((Class)actualTypeArgument), tmpField -> tmpField.getDeclaredAnnotation(ExcludeInHeader.class) == null && !CellValue.class.isAssignableFrom(tmpField.getDeclaringClass()) && !tmpField.isSynthetic() && !tmpField.isEnumConstant());
            for (Map.Entry entry : tmpFieldMap.entrySet()) {
                this.extendField(path + "." + (String)entry.getKey(), (Field)entry.getValue(), fieldMap, false);
            }
        } else if (!include) {
            fieldMap.put(path, field);
        }
    }

    @Override
    public void all(Class<? extends Model> clazz, Segment.Header.I18n i18n) {
        boolean javaTypeAsDataType = true;
        HeaderDef headerDef = clazz.getDeclaredAnnotation(HeaderDef.class);
        if (headerDef != null) {
            this.setDefaultColumnWidth(headerDef.defaultColumnWidth() > 0 ? headerDef.defaultColumnWidth() : 15);
            if (headerDef.fixed()) {
                this.fixed();
            }
            javaTypeAsDataType = headerDef.javaTypeAsDataType();
        }
        final boolean javaTypeAsDataTypeDef = javaTypeAsDataType;
        Map fieldMap = Util.flatProperty(clazz, field -> field.getDeclaredAnnotation(ExcludeInHeader.class) == null && !CellValue.class.isAssignableFrom(field.getDeclaringClass()));
        LinkedHashMap<String, Field> tempFieldMap = new LinkedHashMap<String, Field>(fieldMap);
        for (Map.Entry entry : fieldMap.entrySet()) {
            this.extendField((String)entry.getKey(), (Field)entry.getValue(), tempFieldMap, true);
        }
        for (Map.Entry entry : tempFieldMap.entrySet()) {
            String c = (String)entry.getKey();
            String parentPath = c.substring(0, Math.max(c.lastIndexOf("."), 0));
            String subPath = c.substring(Math.max(c.lastIndexOf(".") + 1, 0));
            final Field field2 = (Field)entry.getValue();
            final CellDef cellDef = field2.getDeclaredAnnotation(CellDef.class);
            CellVirtual cellVirtual = field2.getDeclaredAnnotation(CellVirtual.class);
            FontDef fontDef = field2.getDeclaredAnnotation(FontDef.class);
            HyperlinkDef hyperlinkDef = field2.getDeclaredAnnotation(HyperlinkDef.class);
            this.upset0(parentPath, subPath, new Segment.Header.Width(){

                @Override
                public int width(String path) {
                    return cellDef == null ? 0 : cellDef.width();
                }
            }, null, new Segment.Header.CellType(){

                @Override
                public CellDataType cellType(String path) {
                    CellDataType def;
                    CellDataType cellDataType = def = cellDef == null ? CellDataType.NONE : cellDef.cellDataType();
                    if (def == CellDataType.NONE && javaTypeAsDataTypeDef) {
                        Class<?> type = field2.getType();
                        def = Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type ? CellDataType.BOOLEAN : (Number.class.isAssignableFrom(type) || Integer.TYPE == type || Long.TYPE == type || Short.TYPE == type || Byte.TYPE == type || Float.TYPE == type || Double.TYPE == type ? CellDataType.NUMERIC : CellDataType.STRING);
                    }
                    return def;
                }
            }, headerCell -> {
                String showName;
                headerCell.setTip(cellDef == null ? null : cellDef.tip());
                headerCell.setI18Key(cellDef == null ? null : cellDef.i18Key());
                String string = showName = cellDef == null ? null : cellDef.showName();
                if (Util.isNotEmpty((CharSequence)showName)) {
                    headerCell.setName(showName);
                } else if (Util.isNotEmpty((CharSequence)headerCell.getI18Key())) {
                    showName = i18n.i18n(headerCell.getI18Key());
                    headerCell.setName(showName);
                } else {
                    showName = i18n.i18n(headerCell.getPath());
                    headerCell.setName(showName);
                }
                if (fontDef != null) {
                    headerCell.getHeaderFeature().setFontFeatureEnabled(true);
                    headerCell.getHeaderFeature().setBold(fontDef.bold());
                    headerCell.getHeaderFeature().setUnderline(fontDef.underline());
                    headerCell.getHeaderFeature().setItalic(fontDef.italic());
                    headerCell.getHeaderFeature().setStrikeout(fontDef.strikeout());
                    if (Util.isNotEmpty((CharSequence)fontDef.color())) {
                        headerCell.getHeaderFeature().setColor(fontDef.color());
                    }
                }
                if (hyperlinkDef != null) {
                    headerCell.getHeaderFeature().setHyperlinkFeatureEnabled(true);
                    if (Util.isNotEmpty((CharSequence)hyperlinkDef.type())) {
                        headerCell.getHeaderFeature().setHyperlinkUrl("url".equalsIgnoreCase(hyperlinkDef.type()));
                    }
                }
            }, cellVirtual != null);
        }
    }

    @Override
    public void fixed() {
        this.fixed = true;
    }

    @Override
    public void commit() {
        if (this.committed) {
            return;
        }
        this.committed = true;
        for (HeaderCellImpl cell : this.cellList) {
            int i = cell.calLeafCount();
            cell.setLeafCount(i);
        }
        for (int i = 0; i < this.cellList.size(); ++i) {
            HeaderCellImpl cell;
            cell = this.cellList.get(i);
            if (i == 0) {
                cell.calPosition(0);
                continue;
            }
            HeaderCellImpl b = this.cellList.get(i - 1);
            cell.calPosition(b.getPosition() + b.leafCount());
        }
        this.scanUp2Down(new Segment.Header.Scan(){

            @Override
            public void scan(Segment.Header.Cell cell) {
                HeaderImpl.this.maxHeadIndex = Math.max(HeaderImpl.this.maxHeadIndex, cell.excelX());
            }
        });
        for (HeaderCellImpl headerCell : this.cellList) {
            headerCell.shiftUpY(headerCell.level(), headerCell.isVirtual());
        }
        int l = this.height();
        for (int i = 1; i <= l; ++i) {
            HeaderCellImpl headerCell;
            boolean f = true;
            Iterator<HeaderCellImpl> iterator = this.cellList.iterator();
            while (iterator.hasNext() && (f = (headerCell = iterator.next()).matchYInAllTopCell(i, l))) {
            }
            if (!f) break;
            --this.deltaY;
        }
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public void scanUp2Down(Segment.Header.Scan scan) {
        this.scanUp2Down0(scan, this.cellList);
    }

    private void scanUp2Down0(Segment.Header.Scan scan, List<HeaderCellImpl> cellList) {
        ArrayList<HeaderCellImpl> nextList = new ArrayList<HeaderCellImpl>();
        for (HeaderCellImpl cell : cellList) {
            scan.scan(cell);
            if (!Util.isNotEmpty(cell.getCellList())) continue;
            nextList.addAll(cell.getCellList());
        }
        if (Util.isNotEmpty(nextList)) {
            this.scanUp2Down0(scan, nextList);
        }
    }

    @Override
    public List<String> properties() {
        ArrayList<String> list = new ArrayList<String>();
        this.scanUp2Down(cell -> list.add(cell.property()));
        return list;
    }

    @Override
    public int heightExcludeVirtual() {
        return this.height + this.deltaY;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public List<HeaderCellImpl> getCellList() {
        return this.cellList;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public int getMaxHeadIndex() {
        return this.maxHeadIndex;
    }

    public int getMaxPossibleHeadIndex() {
        return this.maxPossibleHeadIndex;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setDefaultColumnWidth(int defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
    }

    public void setMaxHeadIndex(int maxHeadIndex) {
        this.maxHeadIndex = maxHeadIndex;
    }

    public void setMaxPossibleHeadIndex(int maxPossibleHeadIndex) {
        this.maxPossibleHeadIndex = maxPossibleHeadIndex;
    }

    public void setDeltaY(int deltaY) {
        this.deltaY = deltaY;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeaderImpl)) {
            return false;
        }
        HeaderImpl other = (HeaderImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCommitted() != other.isCommitted()) {
            return false;
        }
        if (this.isFixed() != other.isFixed()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getDefaultColumnWidth() != other.getDefaultColumnWidth()) {
            return false;
        }
        if (this.getMaxHeadIndex() != other.getMaxHeadIndex()) {
            return false;
        }
        if (this.getMaxPossibleHeadIndex() != other.getMaxPossibleHeadIndex()) {
            return false;
        }
        if (this.getDeltaY() != other.getDeltaY()) {
            return false;
        }
        List<HeaderCellImpl> this$cellList = this.getCellList();
        List<HeaderCellImpl> other$cellList = other.getCellList();
        return !(this$cellList == null ? other$cellList != null : !((Object)this$cellList).equals(other$cellList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeaderImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCommitted() ? 79 : 97);
        result = result * 59 + (this.isFixed() ? 79 : 97);
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getDefaultColumnWidth();
        result = result * 59 + this.getMaxHeadIndex();
        result = result * 59 + this.getMaxPossibleHeadIndex();
        result = result * 59 + this.getDeltaY();
        List<HeaderCellImpl> $cellList = this.getCellList();
        result = result * 59 + ($cellList == null ? 43 : ((Object)$cellList).hashCode());
        return result;
    }

    public String toString() {
        return "HeaderImpl(committed=" + this.isCommitted() + ", fixed=" + this.isFixed() + ", cellList=" + this.getCellList() + ", height=" + this.getHeight() + ", defaultColumnWidth=" + this.getDefaultColumnWidth() + ", maxHeadIndex=" + this.getMaxHeadIndex() + ", maxPossibleHeadIndex=" + this.getMaxPossibleHeadIndex() + ", deltaY=" + this.getDeltaY() + ")";
    }

    static interface CellFuncSet<R> {
        public void set(R var1, HeaderCellImpl var2);
    }

    static class HeaderFeatureOperationImpl
    implements Segment.HeaderFeatureOperation {
        private final HeaderCellImpl headerCell;

        public HeaderFeatureOperationImpl(HeaderCellImpl headerCell) {
            this.headerCell = headerCell;
        }

        @Override
        public Segment.HeaderFeatureOperation fontBold(boolean bold) {
            this.headerCell.getHeaderFeature().setFontFeatureEnabled(true);
            this.headerCell.getHeaderFeature().setBold(bold);
            return this;
        }

        @Override
        public Segment.HeaderFeatureOperation fontUnderline(boolean underline) {
            this.headerCell.getHeaderFeature().setFontFeatureEnabled(true);
            this.headerCell.getHeaderFeature().setUnderline(underline);
            return this;
        }

        @Override
        public Segment.HeaderFeatureOperation fontItalic(boolean italic) {
            this.headerCell.getHeaderFeature().setFontFeatureEnabled(true);
            this.headerCell.getHeaderFeature().setItalic(italic);
            return this;
        }

        @Override
        public Segment.HeaderFeatureOperation fontStrikeout(boolean strikeout) {
            this.headerCell.getHeaderFeature().setFontFeatureEnabled(true);
            this.headerCell.getHeaderFeature().setStrikeout(strikeout);
            return this;
        }

        @Override
        public Segment.HeaderFeatureOperation fontColor(String color) {
            this.headerCell.getHeaderFeature().setFontFeatureEnabled(true);
            this.headerCell.getHeaderFeature().setColor(color);
            return this;
        }

        @Override
        public Segment.HeaderFeatureOperation hyperlink(String type) {
            this.headerCell.getHeaderFeature().setHyperlinkFeatureEnabled(true);
            this.headerCell.getHeaderFeature().setHyperlinkUrl("url".equalsIgnoreCase(type));
            return this;
        }
    }
}

