package com.ovopark.iohub.sdk.model;

import com.ovopark.iohub.sdk.model.proto.internal.HeaderCellImpl;
import com.ovopark.iohub.sdk.model.proto.Segment;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.ovopark.kernel.shared.Util.convert2RuntimeException;
import static com.ovopark.kernel.shared.Util.flatProperty;

@Data
public class DynamicFeature implements Model {


    /**
     * regex
     */
    private Map<String, SegmentFeatureSetter> segmentFeatures=new HashMap<>();

    /**
     * k: {{@link HeaderCellImpl#path()}} / regex
     */
    private Map<String, HeaderFeatureSetter> headerFeatures=new HashMap<>();

    @Data
    public static class SegmentFeatureSetter implements Model{

        private List<String> keyList=new ArrayList<>();

        Segment.Feature feature=new Segment.Feature();

        final private static FieldAccessor fieldAccessor=new FieldAccessor(Segment.Feature.class);

        public void set(String property,Object value){
            fieldAccessor.set(property,feature,value);
            if (!keyList.contains(property)) {
                keyList.add(property);
            }
        }

        public <T> T get(String property){
            return fieldAccessor.get(property,feature);
        }

        public boolean validProperty(String property){
            return fieldAccessor.validProperty(property);
        }
    }

    @Data
    public static class HeaderFeatureSetter implements Model{

        private List<String> keyList=new ArrayList<>();

        Segment.HeaderFeature headerFeature=new Segment.HeaderFeature();

        final private static FieldAccessor fieldAccessor=new FieldAccessor(Segment.HeaderFeature.class);

        public void set(String property,Object value){
            fieldAccessor.set(property,headerFeature,value);
            if (!keyList.contains(property)) {
                keyList.add(property);
            }
        }

        public <T> T get(String property){
            return fieldAccessor.get(property,headerFeature);
        }

        public boolean validProperty(String property){
            return fieldAccessor.validProperty(property);
        }

    }

    private static class FieldAccessor{

        final Map<String, Field> fieldMap;

        public FieldAccessor(Class<?> clazz) {
            fieldMap = flatProperty(clazz);
            for (Field field : fieldMap.values()) {
                field.setAccessible(true);
            }
        }

        public void set(String property,Object target,Object value){
            Field field = fieldMap.get(property);
            try {
                field.set(target,value);
            } catch (IllegalAccessException e) {
                throw convert2RuntimeException(e);
            }
        }

        public <T> T get(String property,Object target){
            Field field = fieldMap.get(property);
            try {
                return (T) field.get(target);
            } catch (IllegalAccessException e) {
                throw convert2RuntimeException(e);
            }
        }

        public boolean validProperty(String property){
            return fieldMap.containsKey(property);
        }
    }

}
