package com.ovopark.iohub.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class RenderSegment implements Model {

    private String name;

    private String url;

    private Map<String,Object> meta;

    /**
     * same group , i.e. in same excel file , xlsx
     *   group1        group2         group3
     *   /    \         /    \          /   \
     * sheet  sheet    ...           ...
     *
     */
    private String group;

    private int rowCount;

    private int completedRenderRowCount;

    private String startTimeStr;

    private String endTimeStr;

    private boolean rangeMerge;

    private long rangeMergeCount;

    @JsonIgnore
    private transient List<TransientFunc> transientFuncList;

    private int lastRowNum;

//    private Object headerDef;

}
