package com.ovopark.iohub.sdk.model;

import com.ovopark.iohub.sdk.client.instream.ReadJob;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.List;

@Data
public class JobMeta implements Model , ReadJob.ReadDef {

    private String name;

    private boolean nfs;

    private int segmentCount;

    private int moduleType;

    private int taskType;

    /**
     * export
     */
    private String fileName;

    private String uri;

    /**
     * client app, getting data , client node
     */
    private String clientApp;

    /**
     * render node , reading or writing excel
     */
    private String workApp;

    /**
     * export
     */
    private String customRenderBeanClass;

    /**
     * export
     */
    private boolean sxssf;

    /**
     * import , how to write or read excel
     */
    private boolean xls;

    /**
     * export
     */
    private String excelRowListenerBeanClass;

    /**
     * export
     */
    private String excelHeaderListenerBeanClass;

    /**
     * import
     */
    private String customExcelReadBeanClass;

    /**
     * import
     */
    private int skipColumnCount;

    /**
     * import
     */
    private String onlyForTestFile;

    /**
     * import
     */
    private String sheetIndexList;

    /**
     * import , start 0
     */
    private int headerFromIndex;

    /**
     * import , start 0
     */
    private int headerToIndex;

    /**
     * import m [6,9,7,...]
     */
    private String headerMaxColumnIndexList;

    /**
     * import, start 0
     */
    private int dataStartRowIndex;

    /**
     * export
     * @since 1.29
     */
    private int regionRowCount;

    /**
     * export
     * @since 2.7
     */
    private int waitRenderTimeMinute;

    /**
     * export
     * @since 2.10
     */
    private int rowAccessWindowSize;

    /**
     * import
     * @since 2.20
     */
    private boolean validateHeader;


    /**
     * export
     * @since 3.26
     */
    private List<String> featurePreSet;

    /**
     * export
     * @since 4.1
     */
    private boolean limitDuplicateExport;

    /**
     * export
     * @since 4.1
     */
    private boolean skipValidateMergedRegions;

    @Override
    public String sheetIndexList() {
        return getSheetIndexList();
    }

    @Override
    public int headerFromIndex() {
        return headerFromIndex;
    }

    @Override
    public int headerToIndex() {
        return headerToIndex;
    }

    @Override
    public String headerMaxColumnIndexList() {
        return headerMaxColumnIndexList;
    }

    @Override
    public int dataStartRowIndex() {
        return dataStartRowIndex;
    }
}
