package com.ovopark.iohub.sdk.model.outstream;

import com.ovopark.iohub.sdk.model.proto.OnlyTest;
import com.ovopark.iohub.sdk.model.proto.OutStore;
import com.ovopark.iohub.sdk.model.proto.internal.JobHint;
import com.ovopark.iohub.sdk.model.proto.internal.NFSSegmentModel;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class ExportPushCommitRequest implements Model {


    private String app;

    private String node;

    private long taskId;

    private String workApp;

    private String workNode;

    private List<NFSSegmentModel> nfsSegmentModelList;

    private String fileName;

    private Map<String, OutStore.Group> groupMap;

    private String fileIOUrl;

    private OutStore.Feature feature;

    /**
     * <PRE>
     * 在渲染的时候，可以指定一些hint
     * {@link com.ovopark.iohub.sdk.client.outstream.RenderJob} / {@link com.ovopark.iohub.sdk.client.instream.ReadJob}
     *
     * - 这个只适用于上面两个情况
     * @since 4.15
     */
    @OnlyTest
    private JobHint jobHint;

}
