package com.ovopark.iohub.sdk.model;

import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import lombok.Data;

@Data
public class SysStat implements Model {

    private int cpu;

    private String maxHeap;

    private String heapCommitted;

    private String maxNonHeap;

    private String nonHeapCommitted;



    public static SysStat from(Util.SysStat stat){
        SysStat t=new SysStat();
        t.setCpu(stat.cpu());
        t.setMaxHeap(stat.maxHeap());
        t.setHeapCommitted(stat.heapCommitted());
        t.setMaxNonHeap(stat.maxNonHeap());
        t.setNonHeapCommitted(stat.nonHeapCommitted());
        return t;
    }

}
