package com.ovopark.iohub.sdk.model;

import com.ovopark.iohub.sdk.client.instream.ReadJob;
import com.ovopark.kernel.shared.Model;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class JobMeta implements Model , ReadJob.ReadDef {

    private String name;

    private boolean nfs;

    private int segmentCount;

    private int moduleType;

    private int taskType;

    /**
     * export
     */
    private String fileName;

    private String uri;

    /**
     * client app, getting data , client node
     */
    private String clientApp;

    /**
     * render node , reading or writing excel
     */
    private String workApp;

    /**
     * export
     */
    private String customRenderBeanClass;

    /**
     * export
     */
    private boolean sxssf;

    /**
     * import , how to write or read excel
     */
    private boolean xls;

    /**
     * export
     */
    private String excelRowListenerBeanClass;

    /**
     * export
     */
    private String excelHeaderListenerBeanClass;

    /**
     * import
     */
    private String customExcelReadBeanClass;

    /**
     * import
     */
    private int skipColumnCount;

    /**
     * import
     */
    private String onlyForTestFile;

    /**
     * import
     */
    private String sheetIndexList;

    /**
     * import , start 0
     */
    private int headerFromIndex;

    /**
     * import , start 0
     */
    private int headerToIndex;

    /**
     * import m [6,9,7,...]
     * , start 0
     */
    private String headerMaxColumnIndexList;

    /**
     * import, start 0
     */
    private int dataStartRowIndex;

    /**
     * export
     * @since 1.29
     */
    private int regionRowCount;

    /**
     * export
     * @since 2.7
     */
    private int waitRenderTimeMinute;

    /**
     * export
     * @since 2.10
     */
    private int rowAccessWindowSize;

    /**
     * import
     * @since 2.20
     */
    private boolean validateHeader;


    /**
     * export
     * @since 3.26
     */
    private List<String> featurePreSet;

    /**
     * export
     * @since 4.1
     */
    private boolean limitDuplicateExport;

    /**
     * export
     * @since 4.1
     */
    private boolean skipValidateMergedRegions;

    /**
     * export
     * @since 4.15
     */
    private boolean compressed;

    /**
     * set true if row data is a flat map , not include nest map
     * export
     * @since 5.6
     */
    private boolean dataAtLeaf;

    /**
     *
     * @since 5.10
     */
    private boolean importTaskFlag;

    /**
     * @since 6.6
     * export | import
     */
    private int maxRowCountInMemory=10_000;

    /**
     * @since 6.6
     */
    private int maxClientLogCount=10_000;

    /**
     * @since 6.21
     */
    private boolean webRendered;

    private boolean image2Pdf;

    /**
     * @since 7.0
     */
    private List<String> colorPreSet;

    /**
     * @since 7.4
     */
    private String renderVersion;

    /**
     * @since 7.5
     */
    private boolean picOnImport;

    /**
     * @since 7.11
     */
    private int waitReadExcelTimeMinute;

    /**
     * @since 7.20
     */
    private boolean cellValueAsString;

    /**
     * @since 7.20
     */
    private String excelImportCellListener;


    @Override
    public String sheetIndexList() {
        return getSheetIndexList();
    }

    @Override
    public int headerFromIndex() {
        return headerFromIndex;
    }

    @Override
    public int headerToIndex() {
        return headerToIndex;
    }

    @Override
    public String headerMaxColumnIndexList() {
        return headerMaxColumnIndexList;
    }

    @Override
    public int dataStartRowIndex() {
        return dataStartRowIndex;
    }


    @Override
    public JobMeta clone() throws CloneNotSupportedException {
        JobMeta clone = (JobMeta) super.clone();
        List<String> cloneFeaturePreSet = clone.getFeaturePreSet();
        if (cloneFeaturePreSet!=null) {
            clone.setFeaturePreSet(new ArrayList<>(cloneFeaturePreSet));
        }
        return clone;
    }
}
