package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.model.*;
import com.ovopark.kernel.shared.OnlyPrivate;
import com.ovopark.kernel.shared.OnlyTest;
import lombok.Data;

import java.util.Map;
import java.util.function.Supplier;

public interface JobService {


    JobCreateResponse jobCreate(JobCreateRequest jobCreateRequest);

    TaskCreateResponse taskCreate(TaskCreateRequest taskCreateRequest);

    TaskBulkCreateResponse taskBulkCreate(TaskBulkCreateRequest taskBulkCreateRequest);

    TaskUpdateResponse taskUpdate(TaskUpdateRequest taskUpdateRequest);

    TaskLogPutResponse taskLog(TaskLogPutRequest taskLogPutRequest);

    TaskGetResponse taskGet(TaskGetRequest taskGetRequest);

    TaskMetaGetResponse taskMetaGet(TaskMetaGetRequest taskMetaGetRequest);


    void doOnceOnDevice(Integer deviceStatusId, Integer deviceId, Integer userId, Integer groupId
            , String type, String jsonStr, String desc, String jobId, TaskListener taskListener);

    <T> T doOnceOnDevice(Integer deviceStatusId, Integer deviceId, Integer userId, Integer groupId
            , String type, String jsonStr, String desc, String jobId, TaskCallListener<T> taskCallListener);

    Long cronTaskRegister(String name, String bean, String cron);

    Long cronTaskRegisterViaKafka(String name, String bean,String cron, String kafkaTopic, String partitionKey,JobListenerRunnerKafkaConfig jobListenerRunnerKafkaConfig);

    Long delayTaskRegister(String name, String bean, String args, long triggerTimeMs, int triggerIfMiss, Integer createBy);

    Long delayTaskRegisterViaKafka(String name, String bean, String args, long triggerTimeMs, int triggerIfMiss, Integer creatBy, String kafkaTopic, String partitionKey, JobListenerRunnerKafkaConfig jobListenerRunnerKafkaConfig);

    boolean cancelDelayTask(Long delayTaskId);

    @OnlyTest
    TaskContext mockTaskContext(TaskGetResponse.Task task);

    @OnlyTest
    JobContext mockJobContext(String name,String uri,String args,String jobIdInES);

    boolean register(String jobType,String beanUrl,String group, Long minVer);

    boolean register(String jobType, String beanUrl, String group, Long minVer, TaskListenerRunnerProviderConfig taskListenerRunnerProviderConfig);

    interface TaskListener{

        void on(TaskContext taskContext);

    }

    interface TaskCallListener<T>{

        T on(TaskContext taskContext);

    }


    interface TaskContext extends com.ovopark.kernel.shared.job.TaskContext {

        void status(JobStatus jobStatus);

        void completedDesc(String completedDesc);

        void appendLog(String content);

        TaskGetResponse.Task task();

        void statusManageManually();

        void addRetryCount();

        boolean isCancelled();

        void heartbeatData(Object data);

        JobLog jobLog();

        @OnlyPrivate
        Map<String,Object> capture();

        @OnlyPrivate
        void captureSupplier(Supplier<Map<String,Object>> subCaptureSupplier);

    }

    interface TaskListenerRunnerProvider {

        String name();

        boolean start(String jobType, String beanUrl, String group, Long minVer, TaskListener taskListener
                   ,TaskListenerRunnerProviderConfig taskListenerRunnerProviderConfig);

        void close();

    }

    @Data
    class TaskListenerRunnerProviderConfig{

        private String consumerGroup;

        int concurrency;

        String provider="kafka";

        private String offsetReset ;

        private boolean autoCommit =true;

        private int pollIntervalTimeSec;

        private int maxPollRecords;

        private boolean ignoreTaskIfDone;

        private String partitions;

        private boolean remoteLogEnabled;

    }

    @Data
    class JobListenerRunnerKafkaConfig{

        private String consumerGroup;

        int concurrency;

        private String offsetReset ;

        private boolean autCommit=true;

        private int pollIntervalTimeSec;

    }

    interface JobListenerKafkaRunnerProvider {

        String name();

        boolean start(String topic,String beanUrl,JobListenerRunnerKafkaConfig jobListenerRunnerKafkaConfig);

        void close();

    }

    interface HeartbeatDataListener{
        void onHeartbeatData(Object data);
    }

}
