/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client.kafka;

import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.client.kafka.TaskListenerRunnerViaKafkaProvider;
import com.ovopark.jobhub.sdk.model.TaskCaptureRequest;
import com.ovopark.jobhub.sdk.model.TaskCaptureResponse;
import com.ovopark.jobhub.sdk.model.TaskGetResponse;
import com.ovopark.kernel.shared.Util;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@JobClientActive
@RestController(value="com.ovopark.jobhub.sdk.client.kafka.TaskEndpoint")
@RequestMapping(value={"/feign/jobhub-job/processing"})
public class TaskEndpoint {
    private static final Logger log = LoggerFactory.getLogger(TaskEndpoint.class);
    @Autowired
    TaskListenerRunnerViaKafkaProvider taskListenerRunnerViaKafkaProvider;

    @RequestMapping(value={"/captureTask"})
    @ResponseBody
    public TaskCaptureResponse captureTask(@RequestBody TaskCaptureRequest taskCaptureRequest) {
        TaskCaptureResponse taskCaptureResponse = new TaskCaptureResponse();
        taskCaptureResponse.setSuccess(true);
        String containerId = taskCaptureRequest.getContainerId();
        int partition = taskCaptureRequest.getPartition();
        TaskListenerRunnerViaKafkaProvider.TopicPartitionContext topicPartitionContext = this.taskListenerRunnerViaKafkaProvider.get(containerId, String.valueOf(partition));
        if (topicPartitionContext == null) {
            taskCaptureResponse.setFound(false);
            return taskCaptureResponse;
        }
        TaskListenerRunnerViaKafkaProvider.KafkaTaskContext kafkaTaskContext = topicPartitionContext.kafkaTaskContext;
        TaskGetResponse.Task task = kafkaTaskContext.task();
        taskCaptureResponse.setFound(true);
        taskCaptureResponse.setCaptureTaskIdInES(taskCaptureRequest.getTaskIdInES());
        taskCaptureResponse.setTask(task);
        taskCaptureResponse.setHeartbeatData(topicPartitionContext.getHeartbeatData());
        taskCaptureResponse.setStartTime(topicPartitionContext.getStartTime());
        taskCaptureResponse.setStartTimeStr(Util.formatTime((LocalDateTime)Util.dateTime((long)topicPartitionContext.getStartTime()), (String[])new String[0]));
        if (taskCaptureRequest.isCaptureStack()) {
            Thread ioThread = topicPartitionContext.getIoThread();
            if (ioThread != null) {
                StackTraceElement[] stackTraceElements = ioThread.getStackTrace();
                ArrayList<String> stackList = new ArrayList<String>(stackTraceElements.length);
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    stackList.add(stackTraceElement.toString());
                }
                taskCaptureResponse.setIoThread(ioThread.getName() + "@" + ioThread.hashCode());
                taskCaptureResponse.setIoStackList(stackList);
            }
            Map subCapture = kafkaTaskContext.capture();
            taskCaptureResponse.setSubCapture(subCapture);
        }
        return taskCaptureResponse;
    }
}

