/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.JobHubJobApi;
import com.ovopark.jobhub.sdk.client.JobService;
import com.ovopark.jobhub.sdk.client.SpringBeanUriGetter;
import com.ovopark.jobhub.sdk.model.CronTaskSaveRequest;
import com.ovopark.jobhub.sdk.model.CronTaskSaveResponse;
import com.ovopark.jobhub.sdk.model.JobCreateRequest;
import com.ovopark.jobhub.sdk.model.JobCreateResponse;
import com.ovopark.jobhub.sdk.model.JobStatus;
import com.ovopark.jobhub.sdk.model.TaskCreateRequest;
import com.ovopark.jobhub.sdk.model.TaskCreateResponse;
import com.ovopark.jobhub.sdk.model.TaskLogRequest;
import com.ovopark.jobhub.sdk.model.TaskLogResponse;
import com.ovopark.jobhub.sdk.model.TaskUpdateRequest;
import com.ovopark.jobhub.sdk.model.TaskUpdateResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobServiceImpl
implements JobService {
    private static final Logger log = LoggerFactory.getLogger(JobServiceImpl.class);
    @Autowired
    private JobHubJobApi jobHubJobApi;
    @Autowired(required=false)
    private SpringBeanUriGetter springBeanUriGetter;

    public JobCreateResponse jobCreate(JobCreateRequest jobCreateRequest) {
        BaseResult<JobCreateResponse> baseResult = this.jobHubJobApi.jobCreate(jobCreateRequest);
        if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
            return null;
        }
        return (JobCreateResponse)baseResult.getData();
    }

    public TaskCreateResponse taskCreate(TaskCreateRequest taskCreateRequest) {
        BaseResult<TaskCreateResponse> baseResult = this.jobHubJobApi.taskCreate(taskCreateRequest);
        if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
            return null;
        }
        return (TaskCreateResponse)baseResult.getData();
    }

    public TaskUpdateResponse taskUpdate(TaskUpdateRequest taskUpdateRequest) {
        BaseResult<TaskUpdateResponse> baseResult = this.jobHubJobApi.taskUpdate(taskUpdateRequest);
        if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
            return null;
        }
        return (TaskUpdateResponse)baseResult.getData();
    }

    public TaskLogResponse taskLog(TaskLogRequest taskLogRequest) {
        BaseResult<TaskLogResponse> baseResult = this.jobHubJobApi.taskLog(taskLogRequest);
        if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
            return null;
        }
        return (TaskLogResponse)baseResult.getData();
    }

    public void doOnceOnDevice(Integer deviceStatusId, Integer deviceId, Integer userId, Integer group, String type, String jsonStr, String desc, String jobId, JobService.TaskListener taskListener) {
        TaskCreateRequest taskCreateRequest = new TaskCreateRequest();
        taskCreateRequest.setDeviceStatusId(deviceStatusId);
        taskCreateRequest.setDeviceId(deviceId);
        taskCreateRequest.setUserId(userId);
        taskCreateRequest.setGroupId(group);
        taskCreateRequest.setType(type);
        taskCreateRequest.setJsonStr(jsonStr);
        taskCreateRequest.setDesc(desc);
        taskCreateRequest.setJobId(jobId);
        TaskCreateResponse taskCreateResponse = this.taskCreate(taskCreateRequest);
        log.info("taskCreate: " + JSONAccessor.impl().format((Object)taskCreateResponse));
        TaskContextImpl taskContext = new TaskContextImpl();
        JobStatus jobStatus = JobStatus.COMPLETED;
        try {
            taskListener.on((JobService.TaskContext)taskContext);
            jobStatus = (JobStatus)Util.convert2Self((Object)taskContext.jobStatus, (Object)JobStatus.COMPLETED);
        }
        catch (Exception e) {
            jobStatus = (JobStatus)Util.convert2Self((Object)taskContext.jobStatus, (Object)JobStatus.FAIL);
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
        finally {
            TaskUpdateRequest taskUpdateRequest = new TaskUpdateRequest();
            taskUpdateRequest.setId(taskCreateResponse.getId());
            taskUpdateRequest.setStatus(jobStatus.name());
            taskUpdateRequest.setCompletedDesc(taskContext.getCompletedDesc());
            TaskUpdateResponse taskUpdateResponse = this.taskUpdate(taskUpdateRequest);
            log.info("taskUpdate: " + JSONAccessor.impl().format((Object)taskUpdateResponse));
            List<String> contentList = taskContext.getContentList();
            TaskLogRequest taskLogRequest = new TaskLogRequest();
            taskLogRequest.setDeviceStatusId(deviceStatusId);
            taskLogRequest.setDeviceId(deviceId);
            taskLogRequest.setJobId(jobId);
            taskLogRequest.setTaskId(taskCreateResponse.getId());
            taskLogRequest.setType(type);
            taskLogRequest.setContentList(contentList);
            TaskLogResponse taskLogResponse = this.taskLog(taskLogRequest);
            log.info("taskLog: " + JSONAccessor.impl().format((Object)taskLogResponse));
        }
    }

    public boolean cronRegister(String name, String bean, String cron) {
        CronTaskSaveRequest cronTaskSaveRequest = new CronTaskSaveRequest();
        cronTaskSaveRequest.setName(name);
        cronTaskSaveRequest.setLockName(true);
        cronTaskSaveRequest.setCreateBy(Integer.valueOf(-1));
        cronTaskSaveRequest.setModifyBy(Integer.valueOf(-1));
        cronTaskSaveRequest.setUri(this.springBeanUriGetter.springBean(bean));
        cronTaskSaveRequest.setArgs(null);
        cronTaskSaveRequest.setCron(cron);
        BaseResult<CronTaskSaveResponse> baseResult = this.jobHubJobApi.saveCronTask(cronTaskSaveRequest);
        log.info("create cron task result: " + JSONAccessor.impl().format(baseResult));
        return baseResult != null && baseResult.getIsError() == false && baseResult.getData() != null && ((CronTaskSaveResponse)baseResult.getData()).getId() != null;
    }

    class TaskContextImpl
    implements JobService.TaskContext {
        JobStatus jobStatus;
        String completedDesc;
        List<String> contentList = new ArrayList<String>(100);

        public void status(JobStatus jobStatus) {
            this.jobStatus = jobStatus;
        }

        public void completedDesc(String completedDesc) {
            this.completedDesc = completedDesc;
        }

        public void appendLog(String content) {
            this.contentList.add(content);
        }

        public JobStatus getJobStatus() {
            return this.jobStatus;
        }

        public String getCompletedDesc() {
            return this.completedDesc;
        }

        public List<String> getContentList() {
            return this.contentList;
        }

        public void setJobStatus(JobStatus jobStatus) {
            this.jobStatus = jobStatus;
        }

        public void setCompletedDesc(String completedDesc) {
            this.completedDesc = completedDesc;
        }

        public void setContentList(List<String> contentList) {
            this.contentList = contentList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskContextImpl)) {
                return false;
            }
            TaskContextImpl other = (TaskContextImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JobStatus this$jobStatus = this.getJobStatus();
            JobStatus other$jobStatus = other.getJobStatus();
            if (this$jobStatus == null ? other$jobStatus != null : !this$jobStatus.equals(other$jobStatus)) {
                return false;
            }
            String this$completedDesc = this.getCompletedDesc();
            String other$completedDesc = other.getCompletedDesc();
            if (this$completedDesc == null ? other$completedDesc != null : !this$completedDesc.equals(other$completedDesc)) {
                return false;
            }
            List<String> this$contentList = this.getContentList();
            List<String> other$contentList = other.getContentList();
            return !(this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskContextImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JobStatus $jobStatus = this.getJobStatus();
            result = result * 59 + ($jobStatus == null ? 43 : $jobStatus.hashCode());
            String $completedDesc = this.getCompletedDesc();
            result = result * 59 + ($completedDesc == null ? 43 : $completedDesc.hashCode());
            List<String> $contentList = this.getContentList();
            result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
            return result;
        }

        public String toString() {
            return "JobServiceImpl.TaskContextImpl(jobStatus=" + this.getJobStatus() + ", completedDesc=" + this.getCompletedDesc() + ", contentList=" + this.getContentList() + ")";
        }
    }
}

