package com.ovopark.jobhub.sdk.client;


import com.ovopark.jobhub.sdk.model.internal.delay.AssignedShard;
import com.ovopark.jobhub.sdk.model.internal.delay.NodeView;
import com.ovopark.jobhub.sdk.model.internal.job.AppNodeList;
import com.ovopark.jobhub.sdk.model.internal.job.ClientNodeRegisterRequest;
import com.ovopark.jobhub.sdk.model.internal.job.ClientNodeRegisterResponse;
import com.ovopark.jobhub.sdk.model.internal.job.WorkerNode;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


@FeignClient(value = "jobhub-state"
        ,url = "${jobhub.control.master.url:127.0.0.1:13599}"
)
public interface JobHubStateApi {
    

    @PostMapping("/jobhub-state/feign/delay/shard/nodeView")
    BaseResult<AssignedShard> nodeView(@RequestBody NodeView nodeView);

    @RequestMapping("/jobhub-state/feign/delay/shard/lease")
    BaseResult<Boolean> lease(@RequestParam("nodeName")  String nodeName, @RequestParam("group")  String group);

    @RequestMapping("/jobhub-state/feign/delay/shard/worker")
    BaseResult<List<WorkerNode>> worker();

    @GetMapping("/jobhub-state/feign/cronJob/jobClient/getAppNode")
    BaseResult<AppNodeList> getAppNode(@RequestParam("app") String app);

    @PostMapping("/jobhub-state/feign/cronJob/jobClient/heartbeat")
    BaseResult<ClientNodeRegisterResponse> heartbeat(@RequestBody ClientNodeRegisterRequest clientNodeRegisterRequest);

    @GetMapping("/jobhub-state/assist/cluster/shard/check")
    BaseResult<Map<String,Object>> check();

}
