package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.model.*;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.BaseResult;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

import static com.ovopark.kernel.shared.Util.convert2RuntimeException;
import static com.ovopark.kernel.shared.Util.convert2Self;

@Slf4j
@Component
public class JobServiceImpl implements JobService{

    @Autowired
    private JobHubJobApi jobHubJobApi;


    @Autowired(required = false)
    private SpringBeanUriGetter springBeanUriGetter;


    @Override
    public JobCreateResponse jobCreate(JobCreateRequest jobCreateRequest) {
        BaseResult<JobCreateResponse> baseResult = jobHubJobApi.jobCreate(jobCreateRequest);
        if (baseResult==null || baseResult.getIsError() || baseResult.getData()==null) {
            return null;
        }
        return baseResult.getData();
    }

    @Override
    public TaskCreateResponse taskCreate(TaskCreateRequest taskCreateRequest) {
        BaseResult<TaskCreateResponse> baseResult = jobHubJobApi.taskCreate(taskCreateRequest);
        if (baseResult==null || baseResult.getIsError() || baseResult.getData()==null) {
            return null;
        }
        return baseResult.getData();
    }

    @Override
    public TaskUpdateResponse taskUpdate(TaskUpdateRequest taskUpdateRequest) {
        BaseResult<TaskUpdateResponse> baseResult = jobHubJobApi.taskUpdate(taskUpdateRequest);
        if (baseResult==null || baseResult.getIsError() || baseResult.getData()==null) {
            return null;
        }
        return baseResult.getData();
    }

    @Override
    public TaskLogResponse taskLog(TaskLogRequest taskLogRequest) {
        BaseResult<TaskLogResponse> baseResult = jobHubJobApi.taskLog(taskLogRequest);
        if (baseResult==null || baseResult.getIsError() || baseResult.getData()==null) {
            return null;
        }
        return baseResult.getData();
    }

    @Override
    public void doOnceOnDevice(Integer deviceStatusId, Integer deviceId, Integer userId, Integer group
            , String type, String jsonStr, String desc, String jobId, TaskListener taskListener) {
        doOnceOnDevice(deviceStatusId, deviceId, userId, group, type, jsonStr, desc, jobId, new TaskCallListener<Void>() {
            @Override
            public Void on(TaskContext taskContext) {
                taskListener.on(taskContext);
                return null;
            }
        });
    }

    @Override
    public <T> T doOnceOnDevice(Integer deviceStatusId, Integer deviceId, Integer userId, Integer group, String type, String jsonStr, String desc, String jobId, TaskCallListener<T> taskCallListener) {
        TaskCreateRequest taskCreateRequest=new TaskCreateRequest();
        taskCreateRequest.setDeviceStatusId(deviceStatusId);
        taskCreateRequest.setDeviceId(deviceId);
        taskCreateRequest.setUserId(userId);
        taskCreateRequest.setGroupId(group);
        taskCreateRequest.setType(type);
        taskCreateRequest.setJsonStr(jsonStr);
        taskCreateRequest.setDesc(desc);
        taskCreateRequest.setJobId(jobId);

        TaskCreateResponse taskCreateResponse = taskCreate(taskCreateRequest);
        log.info("taskCreate: "+ JSONAccessor.impl().format(taskCreateResponse));
        TaskContextImpl taskContext= new TaskContextImpl();
        JobStatus jobStatus=JobStatus.COMPLETED;
        TaskUpdateRequest taskUpdateRequest=new TaskUpdateRequest();
        try {
            T f = taskCallListener.on(taskContext);
            jobStatus=convert2Self(taskContext.jobStatus,JobStatus.COMPLETED);
            return f;
        }
        catch (Exception e) {
            jobStatus=convert2Self(taskContext.jobStatus,JobStatus.FAIL);
            log.error(e.getMessage(),e);
            throw convert2RuntimeException(e);
        }
        finally {
            taskUpdateRequest.setId(taskCreateResponse.getId());
            taskUpdateRequest.setStatus(jobStatus.name());
            taskUpdateRequest.setCompletedDesc(taskContext.getCompletedDesc());

            taskUpdateRequest.setRequestDeviceUrl(taskContext.getRequestDeviceUrl());
            taskUpdateRequest.setRequestDeviceArgs(taskContext.getRequestDeviceArgs());
            taskUpdateRequest.setResponseFromDevice(taskContext.getResponseFromDevice());

            TaskUpdateResponse taskUpdateResponse = taskUpdate(taskUpdateRequest);
            log.info("taskUpdate: "+ JSONAccessor.impl().format(taskUpdateResponse));

            List<String> contentList = taskContext.getContentList();
            TaskLogRequest taskLogRequest=new TaskLogRequest();
            taskLogRequest.setDeviceStatusId(deviceStatusId);
            taskLogRequest.setDeviceId(deviceId);
            taskLogRequest.setJobId(jobId);
            taskLogRequest.setTaskId(taskCreateResponse.getId());
            taskLogRequest.setType(type);
            taskLogRequest.setContentList(contentList);

            TaskLogResponse taskLogResponse = taskLog(taskLogRequest);
            log.info("taskLog: "+ JSONAccessor.impl().format(taskLogResponse));

        }
    }

    @Override
    public boolean cronRegister(String name, String bean, String cron){
        CronTaskSaveRequest cronTaskSaveRequest=new CronTaskSaveRequest();
        cronTaskSaveRequest.setName(name);
        cronTaskSaveRequest.setLockName(true); // important!!!
        cronTaskSaveRequest.setCreateBy(-1);
        cronTaskSaveRequest.setModifyBy(-1);

        cronTaskSaveRequest.setUri(springBeanUriGetter.springBean(bean));
        cronTaskSaveRequest.setArgs(null);
        cronTaskSaveRequest.setCron(cron);
//        cronTaskSaveRequest.setCron("0/10 * * * * ?");
        BaseResult<CronTaskSaveResponse> baseResult = jobHubJobApi.saveCronTask(cronTaskSaveRequest);
        log.info("create cron task result: "+ JSONAccessor.impl().format(baseResult));

//        if (baseResult==null || baseResult.getIsError()
//                || baseResult.getData()==null || baseResult.getData().getId()==null) {
//            throw new IllegalStateException("cannot create a new cron task.");
//        }

        return baseResult!=null && !baseResult.getIsError() && baseResult.getData()!=null && baseResult.getData().getId()!=null;
    }



    @Data
    class TaskContextImpl implements TaskContext{

        JobStatus jobStatus;

        String completedDesc;

        List<String> contentList=new ArrayList<>(100);

        String requestDeviceUrl;

        String requestDeviceArgs;

        String responseFromDevice;

        @Override
        public void status(JobStatus jobStatus) {
            this.jobStatus=jobStatus;
        }

        @Override
        public void completedDesc(String completedDesc) {
            this.completedDesc=completedDesc;
        }

        @Override
        public void appendLog(String content) {
            contentList.add(content);
        }

        @Override
        public void requestDeviceUrl(String requestUrl) {
            this.requestDeviceUrl=requestUrl;
        }

        @Override
        public void requestDeviceArgs(String requestArgs) {
            this.requestDeviceArgs=requestArgs;
        }

        @Override
        public void responseFromDevice(String response) {
            this.responseFromDevice=response;
        }
    }


}
