/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.DelayTaskExecutor;
import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.client.JobContext;
import com.ovopark.jobhub.sdk.client.JobLog;
import com.ovopark.jobhub.sdk.client.JobTaskListener;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@JobClientActive
@Component
public class SimpleDelayTaskExecutor
implements DelayTaskExecutor {
    @Autowired
    ApplicationContext applicationContext;
    final Map<String, JobTaskListener> C = new ConcurrentHashMap<String, JobTaskListener>();

    @Override
    public void execute(JobContext jobContext, JobLog jobLog) {
        String uri = jobContext.uri();
        URI u = URI.create(uri);
        if ("bean".equals(u.getScheme()) && "spring".equals(u.getHost())) {
            String beanName = u.getPath().substring(1);
            JobTaskListener bean = this.C.computeIfAbsent(beanName, s -> {
                JobTaskListener b = (JobTaskListener)this.applicationContext.getBean(s);
                return b;
            });
            bean.on(jobContext, jobLog);
        }
    }
}

