package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterRequest;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterResponse;
import com.ovopark.jobhub.sdk.model.internal.TaskLockRequest;
import com.ovopark.jobhub.sdk.model.internal.TaskLockResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobClientActive
@Slf4j
@Component("com.ovopark.jobhub.sdk.client.Client2ControlRestClientRPC")
public class Client2ControlRestClientRPC implements Client2ControlTransport {


    Client2ControlRestClient client2ControlRestClient;

    @Autowired
    public void setControlNodeProxy(ControlNodeProxy controlNodeProxy) {
        this.client2ControlRestClient = new Client2ControlRestClient(controlNodeProxy);
    }


    @Override
    public ClientNodeRegisterResponse heartbeat(ClientNodeRegisterRequest clientNodeRegisterRequest) {
        return client2ControlRestClient.heartbeat(clientNodeRegisterRequest);
    }

    @Override
    public TaskLockResponse lockClient(TaskLockRequest taskLockRequest) {
        return client2ControlRestClient.lockClient(taskLockRequest);
    }

    @Override
    public TaskLogResponse log(TaskLogRequest taskLogRequest) {
        return client2ControlRestClient.log(taskLogRequest);
    }

}
