package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterRequest;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.vclient.ClientNode;
import com.ovopark.kernel.shared.vclient.ClientNodeRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import static com.ovopark.kernel.shared.Util.schedule;

@Slf4j
@JobClientActive
@Component("com.ovopark.jobhub.sdk.client.ClientNodeRegisterImpl")
public class ClientNodeRegisterImpl implements ClientNodeRegister, CommandLineRunner {

    @Autowired
    private com.ovopark.jobhub.sdk.client.ClientNodeProvider clientNodeProvider;

    final static ScheduledExecutorService scheduledExecutorService= Executors.newScheduledThreadPool(1);

    @Autowired
    ControlTransport controlTransport;

    @Override
    public void register() {
        schedule(scheduledExecutorService, () -> {

            ClientNode clientNode = clientNodeProvider.clientNode();
            ClientNodeRegisterRequest clientNodeRegisterRequest=new ClientNodeRegisterRequest();
            clientNodeRegisterRequest.setApp(clientNode.app());
            clientNodeRegisterRequest.setNode(clientNode.node());
            clientNodeRegisterRequest.setIp(clientNode.ip());
            clientNodeRegisterRequest.setPort(clientNode.port());
            clientNodeRegisterRequest.setServletPath(clientNode.servletPath());

            ClientNodeRegisterResponse clientNodeRegisterResponse = controlTransport.heartbeat(clientNodeRegisterRequest);
            log.info(JSONAccessor.impl().format(clientNodeRegisterResponse));
        },5, TimeUnit.SECONDS, e->{
            log.error(e.getMessage());
            return true;
        },()->true);
    }

    @Override
    public void run(String... args) throws Exception {
        register();
    }
}
