package com.ovopark.jobhub.sdk.client;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@JobClientActive
@Primary
@Component("com.ovopark.jobhub.sdk.client.ControlNodeProxy")
public class ControlNodeProxy implements ControlNode{

    @Autowired
    private NacosControlNode nacosControlNode;

    @Autowired
    private ControlNodeImpl controlNodeConfSelf;

    @Override
    public String ip() {
        String ip = nacosControlNode.ip();
        if (!"127.0.0.1".equals(ip)) {
            return ip;
        }
        return controlNodeConfSelf.ip();
    }

    @Override
    public int port() {
        int port = nacosControlNode.port();
        if (port>0) {
            return port;
        }
        return controlNodeConfSelf.port();
    }

    @Override
    public int uiPort() {
        int uiPort = nacosControlNode.uiPort();
        if (uiPort>0) {
            return uiPort;
        }
        return controlNodeConfSelf.uiPort();
    }
}
