package com.ovopark.jobhub.sdk.client;

import com.ovopark.kernel.shared.Util;

public interface DelayTaskExecutor {

    void execute(JobContext jobContext, JobLog jobLog);

    /*
    app://{appName}/{beanName}
     */
    static String springBean(String bean, String appName){
        return "app://"+appName+"/"+bean;
    }

    static String kafkaChannel(String topic, String partitionKey){
        if (Util.isEmpty(partitionKey)) {
            return "kafka://"+topic;
        }
        return "kafka://"+topic+"/"+partitionKey;
    }

}
