package com.ovopark.jobhub.sdk.client;

import com.ovopark.kernel.shared.NetUtil;
import com.ovopark.kernel.shared.vclient.ClientNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;

import java.net.InetAddress;
import java.net.URI;

import static com.ovopark.kernel.shared.Util.isEmpty;
import static com.ovopark.kernel.shared.Util.log;

@JobClientActive
@Component("com.ovopark.jobhub.sdk.client.NacosNodeProvider")
public class NacosNodeProvider implements ClientNodeProvider {


    @Autowired
    private ServiceInstance serviceInstance;

    @Autowired
    private ClientJobConfig clientJobConfig;

    @Value("${server.servlet.context-path}")
    private String contextPath;

    @Value("${JOBHUB_CLIENT_APP:${spring.application.name}}")
    private String app;

    @Override
    public ClientNode clientNode() {
        URI uri = serviceInstance.getUri();
        String registerIp=clientJobConfig.getIp();
        if (isEmpty(registerIp)) {

            if (clientJobConfig.isUseNacosIp()) {
                registerIp=uri.getHost();
            }
            else {
                InetAddress localAddress = NetUtil.getLocalAddress();
                registerIp=localAddress.getHostAddress();
            }
        }

        if (isEmpty(registerIp)) {
            log.error("cannot find right IP , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }

        int port;
        if (clientJobConfig.getPort()>0) {
            port=clientJobConfig.getPort();
        }
        else {
            port=uri.getPort();
        }

        if (port<=0) {
            log.error("cannot find port , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }


        ClientNode.ClientNodeImpl node=new ClientNode.ClientNodeImpl();
//        node.setId(serviceInstance.getServiceId()+":"+ClientNodeRegister.UUID_STR);
        node.setNode(ClientNode.UUID_STR);
        node.setIp(registerIp);
        node.setPort(port);
        node.setServletPath(contextPath);
        node.setApp(app);

        return node;
    }
}
