package com.ovopark.jobhub.sdk.client;


import com.ovopark.jobhub.sdk.model.*;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterRequest;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterResponse;
import com.ovopark.jobhub.sdk.model.internal.TaskLockRequest;
import com.ovopark.jobhub.sdk.model.internal.TaskLockResponse;
import com.ovopark.kernel.shared.vclient.Client2ServerTransport;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value = "jobhub-control"
        ,url = "${LOCAL_CONTROL_URL:}" //http://127.0.0.1:13570
)
public interface JobHubJobApi {

    @PostMapping("/jobhub-control/feign/delay/cronJob/jobClient/heartbeat")
    ClientNodeRegisterResponse heartbeat(@RequestBody ClientNodeRegisterRequest clientNodeRegisterRequest);

    @PostMapping("/jobhub-control/feign/delay/cronJob/jobClient/lockClient")
    TaskLockResponse lockClient(@RequestBody TaskLockRequest taskLockRequest);

    @PostMapping("/jobhub-control/feign/delay/cronJob/jobClient/log")
    Client2ServerTransport.TaskLogResponse log(@RequestBody Client2ServerTransport.TaskLogRequest taskLogRequest);

    @PostMapping("/jobhub-control/feign/delay/cronJob/jobClient/saveCronTask")
    CronTaskSaveResponse saveCronTask(@RequestBody CronTaskSaveRequest cronTaskSaveRequest);

    @PostMapping("/jobhub-control/feign/delay/delayJob/jobClient/saveDelayTask")
    DelayTaskSaveResponse saveDelayTask(@RequestBody DelayTaskSaveRequest delayTaskSaveRequest);

    @PostMapping("/jobhub-control/feign/delay/delayJob/jobClient/cancelDelayTask")
    DelayTaskCancelResponse cancelDelayTask(@RequestBody DelayTaskCancelRequest delayTaskCancelRequest);

    @PostMapping("/jobhub-control/feign/job/jobCreate")
    JobCreateResponse jobCreate(@RequestBody JobCreateRequest jobCreateRequest);

    @PostMapping("/jobhub-control/feign/job/taskCreate")
    TaskCreateResponse taskCreate(@RequestBody TaskCreateRequest taskCreateRequest);

    @PostMapping("/jobhub-control/feign/job/taskBulkCreate")
    TaskBulkCreateResponse taskBulkCreate(@RequestBody TaskBulkCreateRequest taskBulkCreateRequest);

    @PostMapping("/jobhub-control/feign/job/taskUpdate")
    TaskUpdateResponse taskUpdate(@RequestBody TaskUpdateRequest taskUpdateRequest);

    @PostMapping("/jobhub-control/feign/job/taskLog")
    TaskLogPutResponse taskLog(@RequestBody TaskLogPutRequest taskLogPutRequest);

    @PostMapping("/jobhub-control/feign/job/taskGet")
    TaskGetResponse taskGet(@RequestBody TaskGetRequest taskGetRequest);

    @PostMapping("/jobhub-control/feign/job/taskMetaGet")
    TaskMetaGetResponse taskMetaGet(@RequestBody TaskMetaGetRequest taskMetaGetRequest);

    @PostMapping("/jobhub-control/feign/job/jobGet/id")
    JobGetResponse jobGet(@RequestParam String id);


    @PostMapping("/jobhub-control/feign/delay/heartbeatStat")
    TaskHeartbeatResponse heartbeatStat(@RequestBody TaskHeartbeatRequest taskHeartbeatRequest);
}
