package com.ovopark.jobhub.sdk.client;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Slf4j
@Component("com.ovopark.jobhub.sdk.client.SpringBeanUriGetterImpl")
public class SpringBeanUriGetterImpl implements SpringBeanUriGetter{

    @Value("${JOBHUB_CLIENT_APP:${spring.application.name}}")
    private String app;

    @Override
    public String springBean(String bean) {
        return DelayTaskExecutor.springBean(bean,app);
    }
}
