package com.ovopark.jobhub.sdk.client;


import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.Stream;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@JobClientActive
@Component
public class SimpleJobInnerContextMgr implements JobInnerContextMgr{

    final Map<String, JobInnerContext> submitJobMap =new ConcurrentHashMap<>();

    @Override
    public boolean add(long cronTaskId, long cronTaskHistoryId, JobInnerContext jobInnerContext) {
        submitJobMap.put(key(cronTaskId,cronTaskHistoryId),jobInnerContext);
        return true;
    }

    @Override
    public boolean exists(long cronTaskId, long cronTaskHistoryId) {
        return submitJobMap.containsKey(key(cronTaskId,cronTaskHistoryId));
    }

    @Override
    public boolean remove(long cronTaskId, long cronTaskHistoryId) {
        submitJobMap.remove(key(cronTaskId,cronTaskHistoryId));
        return true;
    }

    @Override
    public String key(long cronTaskId, long cronTaskHistoryId) {
        return  cronTaskId + "_" + cronTaskHistoryId;
    }

    @Override
    public JobInnerContext jobInnerContext(long cronTaskId, long cronTaskHistoryId) {
        return submitJobMap.get(key(cronTaskId, cronTaskHistoryId));
    }

    @Override
    public int count() {
        return submitJobMap.size();
    }

    @Override
    public void foreach(CoreSubscriber<JobInnerContext> subscriber) {
        Stream.from(new ArrayList<>(submitJobMap.values())).subscribe(subscriber);
    }
}
