/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.DelayTaskExecutor;
import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.client.JobContext;
import com.ovopark.jobhub.sdk.client.JobLog;
import com.ovopark.jobhub.sdk.client.JobTaskListener;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@JobClientActive
@Component(value="com.ovopark.jobhub.sdk.client.SimpleDelayTaskExecutor")
public class SimpleDelayTaskExecutor
implements DelayTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(SimpleDelayTaskExecutor.class);
    @Autowired
    ApplicationContext applicationContext;
    final Map<String, JobTaskListener> C = new ConcurrentHashMap<String, JobTaskListener>();

    @Override
    public void execute(JobContext jobContext, JobLog jobLog) {
        String uri = jobContext.uri();
        URI u = URI.create(uri);
        String beanName = null;
        if ("bean".equals(u.getScheme()) && "spring".equals(u.getHost())) {
            beanName = u.getPath().substring(1);
        } else if ("kafka".equals(u.getScheme())) {
            String path = u.getPath();
            beanName = path.substring(path.lastIndexOf("/") + 1);
        }
        String finalBeanName = beanName;
        JobTaskListener bean = this.C.computeIfAbsent(beanName, s -> {
            JobTaskListener b = null;
            try {
                b = (JobTaskListener)this.applicationContext.getBean(s);
            }
            catch (BeansException e) {
                log.debug(e.getMessage());
                log.debug("confirm your business, do we ignore the job ???: " + finalBeanName);
                return null;
            }
            return b;
        });
        if (bean == null) {
            return;
        }
        bean.on(jobContext, jobLog);
    }
}

