/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.Client2ControlTransport;
import com.ovopark.jobhub.sdk.client.ClientNodeProvider;
import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.client.JobEndpoint;
import com.ovopark.jobhub.sdk.client.JobInnerContext;
import com.ovopark.jobhub.sdk.client.JobInnerContextMgr;
import com.ovopark.jobhub.sdk.model.JobRuntimeModel;
import com.ovopark.jobhub.sdk.model.JobRuntimeRequest;
import com.ovopark.jobhub.sdk.model.JobRuntimeResponse;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterRequest;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterResponse;
import com.ovopark.jobhub.sdk.model.internal.TaskSubmitRequest;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.vclient.ClientNode;
import com.ovopark.kernel.shared.vclient.ClientNodeRegister;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@JobClientActive
@Component(value="com.ovopark.jobhub.sdk.client.ClientNodeRegisterImpl")
public class ClientNodeRegisterImpl
implements ClientNodeRegister,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ClientNodeRegisterImpl.class);
    @Autowired
    private ClientNodeProvider clientNodeProvider;
    static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    static final ScheduledExecutorService jobRuntimeScheduledExecutorService = Executors.newScheduledThreadPool(1);
    @Autowired
    Client2ControlTransport client2ControlTransport;
    @Autowired
    JobInnerContextMgr jobInnerContextMgr;
    static final LocalDateTime startupTime = LocalDateTime.now();

    public void register() {
        Util.schedule((ScheduledExecutorService)scheduledExecutorService, () -> {
            ClientNode clientNode = this.clientNodeProvider.clientNode();
            ClientNodeRegisterRequest clientNodeRegisterRequest = new ClientNodeRegisterRequest();
            clientNodeRegisterRequest.setApp(clientNode.app());
            clientNodeRegisterRequest.setNode(clientNode.node());
            clientNodeRegisterRequest.setIp(clientNode.ip());
            clientNodeRegisterRequest.setPort(clientNode.port());
            clientNodeRegisterRequest.setServletPath(clientNode.servletPath());
            clientNodeRegisterRequest.setStartupTime(startupTime);
            ClientNodeRegisterResponse clientNodeRegisterResponse = this.client2ControlTransport.heartbeat(clientNodeRegisterRequest);
            log.info(JSONAccessor.impl().format((Object)clientNodeRegisterResponse));
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS, e -> {
            log.error(e.getMessage());
            return true;
        }, () -> true);
        Util.schedule((ScheduledExecutorService)jobRuntimeScheduledExecutorService, () -> {
            final ClientNode clientNode = this.clientNodeProvider.clientNode();
            final ArrayList jobRuntimeModelList = new ArrayList();
            this.jobInnerContextMgr.foreach(new CoreSubscriber<JobInnerContext>(){

                public void onNext(JobInnerContext jobInnerContext) {
                    JobEndpoint.JobContextImpl jobContext = (JobEndpoint.JobContextImpl)jobInnerContext;
                    JobRuntimeModel jobRuntimeModel = new JobRuntimeModel();
                    jobRuntimeModel.setCronTaskId(jobContext.cronTaskId());
                    jobRuntimeModel.setCronTaskHistoryId(jobContext.cronTaskHistoryId());
                    jobRuntimeModel.setJobIdInES(jobContext.jobIdInES());
                    TaskSubmitRequest taskSubmitRequest = jobContext.getTaskSubmitRequest();
                    jobRuntimeModel.setDocIndexName(taskSubmitRequest.getDocIndexName());
                    jobRuntimeModel.setStartTimeMs(jobContext.getStartTime());
                    jobRuntimeModel.setNode(clientNode.node());
                    jobRuntimeModel.setApp(clientNode.app());
                    jobRuntimeModelList.add(jobRuntimeModel);
                }
            });
            JobRuntimeRequest jobRuntimeRequest = new JobRuntimeRequest();
            jobRuntimeRequest.setJobRuntimeModelList(jobRuntimeModelList);
            jobRuntimeRequest.setNode(clientNode.node());
            jobRuntimeRequest.setApp(clientNode.app());
            JobRuntimeResponse jobRuntimeResponse = this.client2ControlTransport.jobRuntimePush(jobRuntimeRequest);
            log.info(JSONAccessor.impl().format((Object)jobRuntimeResponse));
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS, e -> {
            log.error(e.getMessage());
            return true;
        }, () -> true);
    }

    public void run(String ... args) throws Exception {
        this.register();
    }
}

