package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.model.JobRuntimeModel;
import com.ovopark.jobhub.sdk.model.JobRuntimeRequest;
import com.ovopark.jobhub.sdk.model.JobRuntimeResponse;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterRequest;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterResponse;
import com.ovopark.jobhub.sdk.model.internal.TaskSubmitRequest;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.vclient.ClientNode;
import com.ovopark.kernel.shared.vclient.ClientNodeRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import static com.ovopark.kernel.shared.Util.schedule;

@Slf4j
@JobClientActive
@Component("com.ovopark.jobhub.sdk.client.ClientNodeRegisterImpl")
public class ClientNodeRegisterImpl implements ClientNodeRegister, CommandLineRunner {

    @Autowired
    private com.ovopark.jobhub.sdk.client.ClientNodeProvider clientNodeProvider;

    final static ScheduledExecutorService scheduledExecutorService= Executors.newScheduledThreadPool(1);


    final static ScheduledExecutorService jobRuntimeScheduledExecutorService= Executors.newScheduledThreadPool(1);


    @Autowired
    Client2ControlTransport client2ControlTransport;

    @Autowired
    JobInnerContextMgr jobInnerContextMgr;

    final static LocalDateTime startupTime=LocalDateTime.now();

    @Override
    public void register() {
        schedule(scheduledExecutorService, () -> {

            ClientNode clientNode = clientNodeProvider.clientNode();
            ClientNodeRegisterRequest clientNodeRegisterRequest=new ClientNodeRegisterRequest();
            clientNodeRegisterRequest.setApp(clientNode.app());
            clientNodeRegisterRequest.setNode(clientNode.node());
            clientNodeRegisterRequest.setIp(clientNode.ip());
            clientNodeRegisterRequest.setPort(clientNode.port());
            clientNodeRegisterRequest.setServletPath(clientNode.servletPath());
            clientNodeRegisterRequest.setStartupTime(startupTime);

            ClientNodeRegisterResponse clientNodeRegisterResponse = client2ControlTransport.heartbeat(clientNodeRegisterRequest);
            log.info(JSONAccessor.impl().format(clientNodeRegisterResponse));
        },5, TimeUnit.SECONDS, e->{
            log.error(e.getMessage());
            return true;
        },()->true);

        schedule(jobRuntimeScheduledExecutorService, () -> {

            ClientNode clientNode = clientNodeProvider.clientNode();
            List<JobRuntimeModel> jobRuntimeModelList=new ArrayList<>();

            jobInnerContextMgr.foreach(new CoreSubscriber<JobInnerContext>() {
                @Override
                public void onNext(JobInnerContext jobInnerContext) {
                    JobEndpoint.JobContextImpl jobContext = (JobEndpoint.JobContextImpl) jobInnerContext;
                    JobRuntimeModel jobRuntimeModel=new JobRuntimeModel();
                    jobRuntimeModel.setCronTaskId(jobContext.cronTaskId());
                    jobRuntimeModel.setCronTaskHistoryId(jobContext.cronTaskHistoryId());
                    jobRuntimeModel.setJobIdInES(jobContext.jobIdInES());

                    TaskSubmitRequest taskSubmitRequest = jobContext.getTaskSubmitRequest();

                    jobRuntimeModel.setDocIndexName(taskSubmitRequest.getDocIndexName());
                    jobRuntimeModel.setStartTimeMs(jobContext.getStartTime());
                    jobRuntimeModel.setNode(clientNode.node());
                    jobRuntimeModel.setApp(clientNode.app());
                    jobRuntimeModelList.add(jobRuntimeModel);
                }
            });

            JobRuntimeRequest jobRuntimeRequest=new JobRuntimeRequest();
            jobRuntimeRequest.setJobRuntimeModelList(jobRuntimeModelList);
            jobRuntimeRequest.setNode(clientNode.node());
            jobRuntimeRequest.setApp(clientNode.app());

            JobRuntimeResponse jobRuntimeResponse = client2ControlTransport.jobRuntimePush(jobRuntimeRequest);
            log.info(JSONAccessor.impl().format(jobRuntimeResponse));
        },5, TimeUnit.SECONDS, e->{
            log.error(e.getMessage());
            return true;
        },()->true);

    }

    @Override
    public void run(String... args) throws Exception {
        register();
    }
}
