/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.DelayTaskExecutor;
import com.ovopark.jobhub.sdk.client.JobContext;
import com.ovopark.jobhub.sdk.client.JobHubJobApi;
import com.ovopark.jobhub.sdk.client.JobLog;
import com.ovopark.jobhub.sdk.client.JobService;
import com.ovopark.jobhub.sdk.client.SpringBeanUriGetter;
import com.ovopark.jobhub.sdk.model.CronTaskSaveRequest;
import com.ovopark.jobhub.sdk.model.CronTaskSaveResponse;
import com.ovopark.jobhub.sdk.model.DelayTaskCancelRequest;
import com.ovopark.jobhub.sdk.model.DelayTaskCancelResponse;
import com.ovopark.jobhub.sdk.model.DelayTaskSaveRequest;
import com.ovopark.jobhub.sdk.model.DelayTaskSaveResponse;
import com.ovopark.jobhub.sdk.model.JobCreateRequest;
import com.ovopark.jobhub.sdk.model.JobCreateResponse;
import com.ovopark.jobhub.sdk.model.JobStatus;
import com.ovopark.jobhub.sdk.model.JobUpdateRequest;
import com.ovopark.jobhub.sdk.model.JobUpdateResponse;
import com.ovopark.jobhub.sdk.model.TaskBulkCreateRequest;
import com.ovopark.jobhub.sdk.model.TaskBulkCreateResponse;
import com.ovopark.jobhub.sdk.model.TaskCreateRequest;
import com.ovopark.jobhub.sdk.model.TaskCreateResponse;
import com.ovopark.jobhub.sdk.model.TaskGetRequest;
import com.ovopark.jobhub.sdk.model.TaskGetResponse;
import com.ovopark.jobhub.sdk.model.TaskLogPutRequest;
import com.ovopark.jobhub.sdk.model.TaskLogPutResponse;
import com.ovopark.jobhub.sdk.model.TaskMetaGetRequest;
import com.ovopark.jobhub.sdk.model.TaskMetaGetResponse;
import com.ovopark.jobhub.sdk.model.TaskUpdateRequest;
import com.ovopark.jobhub.sdk.model.TaskUpdateResponse;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.OnlyPrivate;
import com.ovopark.kernel.shared.ServiceProvider;
import com.ovopark.kernel.shared.Util;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="com.ovopark.jobhub.sdk.client.JobServiceImpl")
public class JobServiceImpl
implements JobService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(JobServiceImpl.class);
    @Autowired
    private JobHubJobApi jobHubJobApi;
    @Autowired(required=false)
    private SpringBeanUriGetter springBeanUriGetter;
    private List<JobService.TaskListenerRunnerProvider> taskListenerRunnerProviderList;
    private ApplicationContext applicationContext;
    private static final String useDefaultProvider = Config.ConfigPriority.option().getString("JOBHUB_TASK_PROVIDER", "kafka");
    @Autowired(required=false)
    private JobService.JobListenerKafkaRunnerProvider jobListenerKafkaRunnerProvider;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Autowired(required=false)
    public void setTaskListenerRunnerProviderList(List<JobService.TaskListenerRunnerProvider> taskListenerRunnerProviderList) {
        this.taskListenerRunnerProviderList = taskListenerRunnerProviderList;
    }

    public JobCreateResponse jobCreate(JobCreateRequest jobCreateRequest) {
        JobCreateResponse jobCreateResponse = this.jobHubJobApi.jobCreate(jobCreateRequest);
        return jobCreateResponse;
    }

    public JobUpdateResponse jobUpdate(JobUpdateRequest jobUpdateRequest) {
        return this.jobHubJobApi.jobUpdate(jobUpdateRequest);
    }

    public TaskCreateResponse taskCreate(TaskCreateRequest taskCreateRequest) {
        TaskCreateResponse taskCreateResponse = this.jobHubJobApi.taskCreate(taskCreateRequest);
        return taskCreateResponse;
    }

    public TaskBulkCreateResponse taskBulkCreate(TaskBulkCreateRequest taskBulkCreateRequest) {
        TaskBulkCreateResponse taskBulkCreateResponse = this.jobHubJobApi.taskBulkCreate(taskBulkCreateRequest);
        return taskBulkCreateResponse;
    }

    public TaskUpdateResponse taskUpdate(TaskUpdateRequest taskUpdateRequest) {
        TaskUpdateResponse taskUpdateResponse = this.jobHubJobApi.taskUpdate(taskUpdateRequest);
        return taskUpdateResponse;
    }

    public TaskLogPutResponse taskLog(TaskLogPutRequest taskLogPutRequest) {
        TaskLogPutResponse taskLogPutResponse = this.jobHubJobApi.taskLog(taskLogPutRequest);
        return taskLogPutResponse;
    }

    public TaskGetResponse taskGet(TaskGetRequest taskGetRequest) {
        TaskGetResponse taskGetResponse = this.jobHubJobApi.taskGet(taskGetRequest);
        return taskGetResponse;
    }

    public TaskMetaGetResponse taskMetaGet(TaskMetaGetRequest taskMetaGetRequest) {
        try {
            TaskMetaGetResponse taskMetaGetResponse = this.jobHubJobApi.taskMetaGet(taskMetaGetRequest);
            return taskMetaGetResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public void doOnceOnDevice(Integer deviceStatusId, Integer deviceId, Integer userId, Integer groupId, String type, String jsonStr, String desc, String jobId, final JobService.TaskListener taskListener) {
        this.doOnceOnDevice(deviceStatusId, deviceId, userId, groupId, type, jsonStr, desc, jobId, new JobService.TaskCallListener<Void>(){

            public Void on(JobService.TaskContext taskContext) {
                taskListener.on(taskContext);
                return null;
            }
        });
    }

    public <T> T doOnceOnDevice(Integer deviceStatusId, Integer deviceId, Integer userId, Integer groupId, String type, String jsonStr, String desc, String jobId, JobService.TaskCallListener<T> taskCallListener) {
        TaskCreateRequest taskCreateRequest = new TaskCreateRequest();
        taskCreateRequest.setDeviceStatusId(deviceStatusId);
        taskCreateRequest.setDeviceId(deviceId);
        taskCreateRequest.setUserId(userId);
        taskCreateRequest.setGroupId(groupId);
        taskCreateRequest.setType(type);
        taskCreateRequest.setJsonStr(jsonStr);
        taskCreateRequest.setDesc(desc);
        taskCreateRequest.setJobId(jobId);
        TaskCreateResponse taskCreateResponse = this.taskCreate(taskCreateRequest);
        log.info("taskCreate: " + JSONAccessor.impl().format((Object)taskCreateResponse));
        TaskContextImpl taskContext = new TaskContextImpl();
        JobStatus jobStatus = JobStatus.COMPLETED;
        TaskUpdateRequest taskUpdateRequest = new TaskUpdateRequest();
        try {
            Object f = taskCallListener.on((JobService.TaskContext)taskContext);
            jobStatus = (JobStatus)Util.convert2Self((Object)taskContext.jobStatus, (Object)JobStatus.COMPLETED);
            Object object = f;
            return (T)object;
        }
        catch (Exception e) {
            jobStatus = (JobStatus)Util.convert2Self((Object)taskContext.jobStatus, (Object)JobStatus.FAIL);
            log.error(e.getMessage(), (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
        finally {
            if (!taskContext.isStatusManageManually()) {
                taskUpdateRequest.setId(taskCreateResponse.getId());
                taskUpdateRequest.setDocIndexName(taskCreateResponse.getDocIndexName());
                taskUpdateRequest.setStatus(jobStatus.name());
                taskUpdateRequest.setCompletedDesc(taskContext.getCompletedDesc());
                taskUpdateRequest.setRequestDeviceUrl(taskContext.getRequestDeviceUrl());
                taskUpdateRequest.setRequestDeviceArgs(taskContext.getRequestDeviceArgs());
                taskUpdateRequest.setResponseFromDevice(taskContext.getResponseFromDevice());
                TaskUpdateResponse taskUpdateResponse = this.taskUpdate(taskUpdateRequest);
                log.info("taskUpdate: " + JSONAccessor.impl().format((Object)taskUpdateResponse));
            }
            List<String> contentList = taskContext.getContentList();
            TaskLogPutRequest taskLogPutRequest = new TaskLogPutRequest();
            taskLogPutRequest.setDeviceStatusId(deviceStatusId);
            taskLogPutRequest.setDeviceId(deviceId);
            taskLogPutRequest.setJobId(jobId);
            taskLogPutRequest.setTaskId(taskCreateResponse.getId());
            taskLogPutRequest.setType(type);
            taskLogPutRequest.setContentList(contentList);
            TaskLogPutResponse taskLogPutResponse = this.taskLog(taskLogPutRequest);
            log.info("taskLog: " + JSONAccessor.impl().format((Object)taskLogPutResponse));
        }
    }

    public Long cronTaskRegister(String name, String bean, String cron) {
        String uri = this.springBeanUriGetter.springBean(bean);
        return this.cronTaskRegister0(name, bean, cron, uri, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long cronTaskRegister0(String name, String bean, String cron, String uri, JobService.JobListenerRunnerKafkaConfig jobListenerRunnerKafkaConfig, String kafkaTopic) {
        try {
            CronTaskSaveRequest cronTaskSaveRequest = new CronTaskSaveRequest();
            cronTaskSaveRequest.setName(name);
            cronTaskSaveRequest.setLockName(true);
            cronTaskSaveRequest.setCreateBy(Integer.valueOf(-1));
            cronTaskSaveRequest.setModifyBy(Integer.valueOf(-1));
            cronTaskSaveRequest.setUri(uri);
            cronTaskSaveRequest.setArgs(null);
            cronTaskSaveRequest.setCron(cron);
            CronTaskSaveResponse cronTaskSaveResponse = this.jobHubJobApi.saveCronTask(cronTaskSaveRequest);
            log.info("create cron task result: " + JSONAccessor.impl().format((Object)cronTaskSaveResponse));
            if (cronTaskSaveResponse != null) {
                Long l = cronTaskSaveResponse.getId();
                return l;
            }
            Long l = null;
            return l;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Long l = null;
            return l;
        }
        finally {
            if (jobListenerRunnerKafkaConfig != null) {
                this.jobListenerKafkaRunnerProvider.start(kafkaTopic, bean, jobListenerRunnerKafkaConfig);
            }
        }
    }

    public Long cronTaskRegisterViaKafka(String name, String bean, String cron, String kafkaTopic, String partitionKey, JobService.JobListenerRunnerKafkaConfig jobListenerRunnerKafkaConfig) {
        String uri = DelayTaskExecutor.kafkaChannel(kafkaTopic, partitionKey, bean);
        return this.cronTaskRegister0(name, bean, cron, uri, jobListenerRunnerKafkaConfig, kafkaTopic);
    }

    public Long delayTaskRegister(String name, String bean, String args, long triggerTimeMs, int triggerIfMiss, Integer createBy) {
        String uri = this.springBeanUriGetter.springBean(bean);
        return this.delayTaskRegister0(name, bean, args, triggerTimeMs, triggerIfMiss, createBy, uri, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long delayTaskRegister0(String name, String bean, String args, long triggerTimeMs, int triggerIfMiss, Integer createBy, String uri, JobService.JobListenerRunnerKafkaConfig jobListenerRunnerKafkaConfig, String kafkaTopic) {
        DelayTaskSaveRequest cronTaskSaveRequest = new DelayTaskSaveRequest();
        cronTaskSaveRequest.setName(name);
        cronTaskSaveRequest.setCreateBy(createBy);
        cronTaskSaveRequest.setModifyBy(Integer.valueOf(-1));
        cronTaskSaveRequest.setUri(uri);
        cronTaskSaveRequest.setArgs(args);
        cronTaskSaveRequest.setTriggerIfMiss(triggerIfMiss);
        cronTaskSaveRequest.setTriggerTimeMs(triggerTimeMs);
        try {
            DelayTaskSaveResponse delayTaskSaveResponse = this.jobHubJobApi.saveDelayTask(cronTaskSaveRequest);
            log.info("create delay task result: " + JSONAccessor.impl().format((Object)delayTaskSaveResponse));
            if (delayTaskSaveResponse != null) {
                Long l = delayTaskSaveResponse.getId();
                return l;
            }
            Long l = null;
            return l;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Long l = null;
            return l;
        }
        finally {
            if (jobListenerRunnerKafkaConfig != null) {
                this.jobListenerKafkaRunnerProvider.start(kafkaTopic, bean, jobListenerRunnerKafkaConfig);
            }
        }
    }

    public Long delayTaskRegisterViaKafka(String name, String bean, String args, long triggerTimeMs, int triggerIfMiss, Integer createBy, String kafkaTopic, String partitionKey, JobService.JobListenerRunnerKafkaConfig jobListenerRunnerKafkaConfig) {
        String uri = DelayTaskExecutor.kafkaChannel(kafkaTopic, partitionKey, bean);
        return this.delayTaskRegister0(name, bean, args, triggerTimeMs, triggerIfMiss, createBy, uri, jobListenerRunnerKafkaConfig, kafkaTopic);
    }

    public boolean cancelDelayTask(Long delayTaskId) {
        DelayTaskCancelRequest delayTaskCancelRequest = new DelayTaskCancelRequest();
        delayTaskCancelRequest.setId(delayTaskId);
        DelayTaskCancelResponse delayTaskCancelResponse = this.jobHubJobApi.cancelDelayTask(delayTaskCancelRequest);
        if (delayTaskCancelResponse == null) {
            return false;
        }
        return delayTaskCancelResponse.isSuccess();
    }

    public JobService.TaskContext mockTaskContext(TaskGetResponse.Task task) {
        TaskContextImpl taskContext = new TaskContextImpl();
        taskContext.setTask(task);
        taskContext.setJobLog(JobLog.noopIfNull(null));
        AtomicBoolean cancelled = new AtomicBoolean();
        taskContext.setHeartbeatDataListener(data -> {});
        taskContext.setCancelledSupplier((Supplier<Boolean>)((ServiceProvider)cancelled::get));
        return taskContext;
    }

    public JobContext mockJobContext(final String name, final String uri, final String args, String jobIdInES) {
        if (Util.isEmpty((CharSequence)jobIdInES)) {
            JobCreateRequest jobCreateRequest = new JobCreateRequest();
            jobCreateRequest.setJsonStr(args);
            jobCreateRequest.setType("mockJobContext");
            jobCreateRequest.setDesc("mockJobContext");
            JobCreateResponse jobCreateResponse = this.jobCreate(jobCreateRequest);
            jobIdInES = jobCreateResponse.getId();
        }
        final String finalJobIdInES = jobIdInES;
        return new JobContext(){

            public Long jobId() {
                return 0L;
            }

            public String name() {
                return name;
            }

            public String uri() {
                return uri;
            }

            public String args() {
                return args;
            }

            public String jobIdInES() {
                return finalJobIdInES;
            }

            public JobService jobService() {
                return JobServiceImpl.this;
            }

            public boolean isCancelled() {
                return false;
            }

            public void heartbeatData(Object data) {
            }
        };
    }

    public boolean register(String jobType, String beanUrl, String group, Long minVer) {
        JobService.TaskListenerRunnerProviderConfig taskListenerRunnerProviderConfig = new JobService.TaskListenerRunnerProviderConfig();
        taskListenerRunnerProviderConfig.setConcurrency(1);
        return this.register(jobType, beanUrl, group, minVer, taskListenerRunnerProviderConfig);
    }

    public boolean register(String jobType, String beanUrl, String group, Long minVer, JobService.TaskListenerRunnerProviderConfig taskListenerRunnerProviderConfig) {
        Object object = this.applicationContext.getBean(beanUrl);
        if (!(object instanceof JobService.TaskListener)) {
            throw new RuntimeException("bean must implement " + JobService.TaskListener.class.getName());
        }
        String realProvider = Util.isNotEmpty((CharSequence)useDefaultProvider) ? useDefaultProvider : taskListenerRunnerProviderConfig.getProvider();
        JobService.TaskListenerRunnerProvider found = null;
        for (JobService.TaskListenerRunnerProvider taskListenerRunnerProvider : this.taskListenerRunnerProviderList) {
            if (!realProvider.equalsIgnoreCase(taskListenerRunnerProvider.name())) continue;
            found = taskListenerRunnerProvider;
            break;
        }
        if (found == null) {
            throw new RuntimeException("cannot find provider, missing kafka dependency ???: jobhub-sdk-client-kafka ");
        }
        return found.start(jobType, beanUrl, group, minVer, (JobService.TaskListener)object, taskListenerRunnerProviderConfig);
    }

    public static class TaskContextImpl
    implements JobService.TaskContext {
        public static final int MAX_CAPACITY = 100;
        JobStatus jobStatus;
        String completedDesc;
        List<String> contentList = new ArrayList<String>(100);
        String requestDeviceUrl;
        String requestDeviceArgs;
        String responseFromDevice;
        TaskGetResponse.Task task;
        boolean statusManageManually;
        JobService.HeartbeatDataListener heartbeatDataListener;
        Supplier<Boolean> cancelledSupplier;
        Supplier<Map<String, Object>> subCaptureSupplier;
        final AtomicBoolean finalCancelled = new AtomicBoolean(false);
        JobLog jobLog;
        private final long taskStartTimeMs = System.currentTimeMillis();
        private final String taskStartTimeStr = Util.formatTime((LocalDateTime)Util.dateTime((long)this.taskStartTimeMs), (String[])new String[0]);

        public void status(JobStatus jobStatus) {
            this.jobStatus = jobStatus;
        }

        public void completedDesc(String completedDesc) {
            this.completedDesc = completedDesc;
        }

        public synchronized void appendLog(String content) {
            if (this.contentList.size() > 100) {
                return;
            }
            this.append0(content);
        }

        @OnlyPrivate
        public void append0(String content) {
            this.contentList.add(Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + " > " + content);
        }

        public TaskGetResponse.Task task() {
            return this.task;
        }

        public void statusManageManually() {
            this.statusManageManually = true;
        }

        public synchronized void addRetryCount() {
            this.task.setRetryCount(Integer.valueOf(Optional.ofNullable(this.task().getRetryCount()).orElse(0) + 1));
        }

        public boolean isCancelled() {
            if (this.finalCancelled.get()) {
                return true;
            }
            Boolean f = this.cancelledSupplier.get();
            if (f.booleanValue()) {
                this.finalCancelled.set(true);
            }
            return f;
        }

        public void heartbeatData(Object data) {
            this.heartbeatDataListener.onHeartbeatData(data);
        }

        public JobLog jobLog() {
            return this.jobLog;
        }

        public Map<String, Object> capture() {
            return this.subCaptureSupplier == null ? new HashMap() : this.subCaptureSupplier.get();
        }

        public void captureSupplier(Supplier<Map<String, Object>> subCaptureSupplier) {
            this.subCaptureSupplier = subCaptureSupplier;
        }

        public void requestDeviceUrl(String requestUrl) {
            this.requestDeviceUrl = requestUrl;
        }

        public void requestDeviceArgs(String requestArgs) {
            this.requestDeviceArgs = requestArgs;
        }

        public void responseFromDevice(String response) {
            this.responseFromDevice = response;
        }

        public JobStatus getJobStatus() {
            return this.jobStatus;
        }

        public String getCompletedDesc() {
            return this.completedDesc;
        }

        public List<String> getContentList() {
            return this.contentList;
        }

        public String getRequestDeviceUrl() {
            return this.requestDeviceUrl;
        }

        public String getRequestDeviceArgs() {
            return this.requestDeviceArgs;
        }

        public String getResponseFromDevice() {
            return this.responseFromDevice;
        }

        public TaskGetResponse.Task getTask() {
            return this.task;
        }

        public boolean isStatusManageManually() {
            return this.statusManageManually;
        }

        public JobService.HeartbeatDataListener getHeartbeatDataListener() {
            return this.heartbeatDataListener;
        }

        public Supplier<Boolean> getCancelledSupplier() {
            return this.cancelledSupplier;
        }

        public Supplier<Map<String, Object>> getSubCaptureSupplier() {
            return this.subCaptureSupplier;
        }

        public AtomicBoolean getFinalCancelled() {
            return this.finalCancelled;
        }

        public JobLog getJobLog() {
            return this.jobLog;
        }

        public long getTaskStartTimeMs() {
            return this.taskStartTimeMs;
        }

        public String getTaskStartTimeStr() {
            return this.taskStartTimeStr;
        }

        public void setJobStatus(JobStatus jobStatus) {
            this.jobStatus = jobStatus;
        }

        public void setCompletedDesc(String completedDesc) {
            this.completedDesc = completedDesc;
        }

        public void setContentList(List<String> contentList) {
            this.contentList = contentList;
        }

        public void setRequestDeviceUrl(String requestDeviceUrl) {
            this.requestDeviceUrl = requestDeviceUrl;
        }

        public void setRequestDeviceArgs(String requestDeviceArgs) {
            this.requestDeviceArgs = requestDeviceArgs;
        }

        public void setResponseFromDevice(String responseFromDevice) {
            this.responseFromDevice = responseFromDevice;
        }

        public void setTask(TaskGetResponse.Task task) {
            this.task = task;
        }

        public void setStatusManageManually(boolean statusManageManually) {
            this.statusManageManually = statusManageManually;
        }

        public void setHeartbeatDataListener(JobService.HeartbeatDataListener heartbeatDataListener) {
            this.heartbeatDataListener = heartbeatDataListener;
        }

        public void setCancelledSupplier(Supplier<Boolean> cancelledSupplier) {
            this.cancelledSupplier = cancelledSupplier;
        }

        public void setSubCaptureSupplier(Supplier<Map<String, Object>> subCaptureSupplier) {
            this.subCaptureSupplier = subCaptureSupplier;
        }

        public void setJobLog(JobLog jobLog) {
            this.jobLog = jobLog;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskContextImpl)) {
                return false;
            }
            TaskContextImpl other = (TaskContextImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isStatusManageManually() != other.isStatusManageManually()) {
                return false;
            }
            if (this.getTaskStartTimeMs() != other.getTaskStartTimeMs()) {
                return false;
            }
            JobStatus this$jobStatus = this.getJobStatus();
            JobStatus other$jobStatus = other.getJobStatus();
            if (this$jobStatus == null ? other$jobStatus != null : !this$jobStatus.equals(other$jobStatus)) {
                return false;
            }
            String this$completedDesc = this.getCompletedDesc();
            String other$completedDesc = other.getCompletedDesc();
            if (this$completedDesc == null ? other$completedDesc != null : !this$completedDesc.equals(other$completedDesc)) {
                return false;
            }
            List<String> this$contentList = this.getContentList();
            List<String> other$contentList = other.getContentList();
            if (this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList)) {
                return false;
            }
            String this$requestDeviceUrl = this.getRequestDeviceUrl();
            String other$requestDeviceUrl = other.getRequestDeviceUrl();
            if (this$requestDeviceUrl == null ? other$requestDeviceUrl != null : !this$requestDeviceUrl.equals(other$requestDeviceUrl)) {
                return false;
            }
            String this$requestDeviceArgs = this.getRequestDeviceArgs();
            String other$requestDeviceArgs = other.getRequestDeviceArgs();
            if (this$requestDeviceArgs == null ? other$requestDeviceArgs != null : !this$requestDeviceArgs.equals(other$requestDeviceArgs)) {
                return false;
            }
            String this$responseFromDevice = this.getResponseFromDevice();
            String other$responseFromDevice = other.getResponseFromDevice();
            if (this$responseFromDevice == null ? other$responseFromDevice != null : !this$responseFromDevice.equals(other$responseFromDevice)) {
                return false;
            }
            TaskGetResponse.Task this$task = this.getTask();
            TaskGetResponse.Task other$task = other.getTask();
            if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
                return false;
            }
            JobService.HeartbeatDataListener this$heartbeatDataListener = this.getHeartbeatDataListener();
            JobService.HeartbeatDataListener other$heartbeatDataListener = other.getHeartbeatDataListener();
            if (this$heartbeatDataListener == null ? other$heartbeatDataListener != null : !this$heartbeatDataListener.equals(other$heartbeatDataListener)) {
                return false;
            }
            Supplier<Boolean> this$cancelledSupplier = this.getCancelledSupplier();
            Supplier<Boolean> other$cancelledSupplier = other.getCancelledSupplier();
            if (this$cancelledSupplier == null ? other$cancelledSupplier != null : !this$cancelledSupplier.equals(other$cancelledSupplier)) {
                return false;
            }
            Supplier<Map<String, Object>> this$subCaptureSupplier = this.getSubCaptureSupplier();
            Supplier<Map<String, Object>> other$subCaptureSupplier = other.getSubCaptureSupplier();
            if (this$subCaptureSupplier == null ? other$subCaptureSupplier != null : !this$subCaptureSupplier.equals(other$subCaptureSupplier)) {
                return false;
            }
            AtomicBoolean this$finalCancelled = this.getFinalCancelled();
            AtomicBoolean other$finalCancelled = other.getFinalCancelled();
            if (this$finalCancelled == null ? other$finalCancelled != null : !this$finalCancelled.equals(other$finalCancelled)) {
                return false;
            }
            JobLog this$jobLog = this.getJobLog();
            JobLog other$jobLog = other.getJobLog();
            if (this$jobLog == null ? other$jobLog != null : !this$jobLog.equals(other$jobLog)) {
                return false;
            }
            String this$taskStartTimeStr = this.getTaskStartTimeStr();
            String other$taskStartTimeStr = other.getTaskStartTimeStr();
            return !(this$taskStartTimeStr == null ? other$taskStartTimeStr != null : !this$taskStartTimeStr.equals(other$taskStartTimeStr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskContextImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isStatusManageManually() ? 79 : 97);
            long $taskStartTimeMs = this.getTaskStartTimeMs();
            result = result * 59 + (int)($taskStartTimeMs >>> 32 ^ $taskStartTimeMs);
            JobStatus $jobStatus = this.getJobStatus();
            result = result * 59 + ($jobStatus == null ? 43 : $jobStatus.hashCode());
            String $completedDesc = this.getCompletedDesc();
            result = result * 59 + ($completedDesc == null ? 43 : $completedDesc.hashCode());
            List<String> $contentList = this.getContentList();
            result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
            String $requestDeviceUrl = this.getRequestDeviceUrl();
            result = result * 59 + ($requestDeviceUrl == null ? 43 : $requestDeviceUrl.hashCode());
            String $requestDeviceArgs = this.getRequestDeviceArgs();
            result = result * 59 + ($requestDeviceArgs == null ? 43 : $requestDeviceArgs.hashCode());
            String $responseFromDevice = this.getResponseFromDevice();
            result = result * 59 + ($responseFromDevice == null ? 43 : $responseFromDevice.hashCode());
            TaskGetResponse.Task $task = this.getTask();
            result = result * 59 + ($task == null ? 43 : $task.hashCode());
            JobService.HeartbeatDataListener $heartbeatDataListener = this.getHeartbeatDataListener();
            result = result * 59 + ($heartbeatDataListener == null ? 43 : $heartbeatDataListener.hashCode());
            Supplier<Boolean> $cancelledSupplier = this.getCancelledSupplier();
            result = result * 59 + ($cancelledSupplier == null ? 43 : $cancelledSupplier.hashCode());
            Supplier<Map<String, Object>> $subCaptureSupplier = this.getSubCaptureSupplier();
            result = result * 59 + ($subCaptureSupplier == null ? 43 : $subCaptureSupplier.hashCode());
            AtomicBoolean $finalCancelled = this.getFinalCancelled();
            result = result * 59 + ($finalCancelled == null ? 43 : $finalCancelled.hashCode());
            JobLog $jobLog = this.getJobLog();
            result = result * 59 + ($jobLog == null ? 43 : $jobLog.hashCode());
            String $taskStartTimeStr = this.getTaskStartTimeStr();
            result = result * 59 + ($taskStartTimeStr == null ? 43 : $taskStartTimeStr.hashCode());
            return result;
        }

        public String toString() {
            return "JobServiceImpl.TaskContextImpl(jobStatus=" + this.getJobStatus() + ", completedDesc=" + this.getCompletedDesc() + ", contentList=" + this.getContentList() + ", requestDeviceUrl=" + this.getRequestDeviceUrl() + ", requestDeviceArgs=" + this.getRequestDeviceArgs() + ", responseFromDevice=" + this.getResponseFromDevice() + ", task=" + this.getTask() + ", statusManageManually=" + this.isStatusManageManually() + ", heartbeatDataListener=" + this.getHeartbeatDataListener() + ", cancelledSupplier=" + this.getCancelledSupplier() + ", subCaptureSupplier=" + this.getSubCaptureSupplier() + ", finalCancelled=" + this.getFinalCancelled() + ", jobLog=" + this.getJobLog() + ", taskStartTimeMs=" + this.getTaskStartTimeMs() + ", taskStartTimeStr=" + this.getTaskStartTimeStr() + ")";
        }
    }
}

