/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.jobhub.sdk.client.Client2ControlTransport;
import com.ovopark.jobhub.sdk.client.DelayTaskExecutor;
import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.client.JobContext;
import com.ovopark.jobhub.sdk.client.JobInnerContext;
import com.ovopark.jobhub.sdk.client.JobInnerContextMgr;
import com.ovopark.jobhub.sdk.client.JobLog;
import com.ovopark.jobhub.sdk.client.JobLogImpl;
import com.ovopark.jobhub.sdk.client.JobService;
import com.ovopark.jobhub.sdk.model.JobCaptureRequest;
import com.ovopark.jobhub.sdk.model.JobCaptureResponse;
import com.ovopark.jobhub.sdk.model.JobStatus;
import com.ovopark.jobhub.sdk.model.JobUpdateRequest;
import com.ovopark.jobhub.sdk.model.JobUpdateResponse;
import com.ovopark.jobhub.sdk.model.internal.TaskLockRequest;
import com.ovopark.jobhub.sdk.model.internal.TaskLockResponse;
import com.ovopark.jobhub.sdk.model.internal.TaskSubmitRequest;
import com.ovopark.jobhub.sdk.model.internal.TaskSubmitResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.OnlyPrivate;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vclient.ClientNode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@JobClientActive
@RestController(value="com.ovopark.jobhub.sdk.client.JobEndpoint")
@RequestMapping(value={"/feign/jobhub-job/processing"})
public class JobEndpoint {
    private static final Logger log = LoggerFactory.getLogger(JobEndpoint.class);
    @Autowired
    private DelayTaskExecutor delayTaskExecutor;
    @Autowired
    private Client2ControlTransport client2ControlTransport;
    @Autowired
    private JobService jobService;
    private static final ExecutorService jobExecutor = new ThreadPoolExecutor(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 64), Integer.parseInt(System.getProperty("JOBHUB_JOB_IO", "0"))), Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2, 1024), Integer.parseInt(System.getProperty("JOBHUB_JOB_IO", "0"))), 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Util.newThreadFactory((String)"jobhub-job-io"), new ThreadPoolExecutor.AbortPolicy());
    @Autowired
    JobInnerContextMgr jobInnerContextMgr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/submit"})
    @ResponseBody
    public TaskSubmitResponse submit(final @RequestBody TaskSubmitRequest taskSubmitRequest) {
        final long cronTaskId = taskSubmitRequest.getCronTaskId();
        final long cronTaskHistoryId = taskSubmitRequest.getCronTaskHistoryId();
        final String jobIdInES = taskSubmitRequest.getJobIdInES();
        final String docIndexName = taskSubmitRequest.getDocIndexName();
        final String taskKey = "task_" + this.jobInnerContextMgr.key(cronTaskId, cronTaskHistoryId);
        MDC.put((String)"traceId", (String)taskKey);
        MDC.put((String)"requestId", (String)taskKey);
        log.info("receive a new task, we can do it???: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
        final TaskSubmitResponse taskSubmitResponse = new TaskSubmitResponse();
        taskSubmitResponse.setSubmitted(false);
        final JobLogImpl logBeforeSubmitted = new JobLogImpl(this.client2ControlTransport, taskKey, cronTaskHistoryId);
        Util.logLink((String)("receive a new task, we can do it???: " + JSONAccessor.impl().format((Object)taskSubmitRequest))).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
        try {
            Util.lock((Comparable)((Object)taskKey), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (JobEndpoint.this.jobInnerContextMgr.exists(cronTaskId, cronTaskHistoryId)) {
                        taskSubmitResponse.setSubmitted(false);
                        taskSubmitResponse.setDesc("Rejected,the previous task is executing");
                        Util.logLink((String)"Rejected,the previous task is executing").log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
                        throw new IllegalStateException("the previous task is executing, reject the task: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
                    }
                    TaskLockRequest taskLockRequest = new TaskLockRequest();
                    taskLockRequest.setCronTaskId(cronTaskId);
                    taskLockRequest.setCronTaskHistoryId(cronTaskHistoryId);
                    taskLockRequest.setNode(ClientNode.UUID_STR);
                    TaskLockResponse taskLockResponse = JobEndpoint.this.client2ControlTransport.lockClient(taskLockRequest);
                    if (taskLockResponse == null || !taskLockResponse.isSuccess()) {
                        Util.logLink((String)("cannot get lock: " + JSONAccessor.impl().format((Object)taskLockRequest))).log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
                        throw new IllegalStateException("cannot get lock: " + JSONAccessor.impl().format((Object)taskLockRequest));
                    }
                    JobLogImpl jobLog = new JobLogImpl(JobEndpoint.this.client2ControlTransport, taskKey, cronTaskHistoryId);
                    JobContextImpl jobContext = new JobContextImpl(taskSubmitRequest, JobEndpoint.this.jobService);
                    jobContext.setCronTaskId(cronTaskId);
                    jobContext.setCronTaskHistoryId(cronTaskHistoryId);
                    try {
                        Future<?> future = jobExecutor.submit(Util.catchRunnable(() -> {
                            jobContext.setIoThread(Thread.currentThread());
                            JobUpdateRequest jobUpdateRequest = new JobUpdateRequest();
                            jobUpdateRequest.setDocIndexName(docIndexName);
                            jobUpdateRequest.setId(jobIdInES);
                            jobUpdateRequest.setStatus(JobStatus.COMPLETED.name());
                            try {
                                JobEndpoint.this.delayTaskExecutor.execute(jobContext, jobLog);
                                jobUpdateRequest.setStatus(JobStatus.SUCCESS.name());
                            }
                            catch (Exception e) {
                                jobUpdateRequest.setStatus(JobStatus.FAIL.name());
                                log.error(e.getMessage(), (Throwable)e);
                                jobLog.flush();
                                Util.errorStackList((Throwable)e).forEach(arg_0 -> ((JobLog)jobLog).log(arg_0));
                                jobLog.flush();
                            }
                            finally {
                                try {
                                    JobUpdateResponse jobUpdateResponse = JobEndpoint.this.jobService.jobUpdate(jobUpdateRequest);
                                    Util.logLink((String)(taskKey + " > jobUpdateResponse: " + JSONAccessor.impl().format((Object)jobUpdateResponse))).log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)jobLog).log(arg_0));
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                                JobEndpoint.this.jobInnerContextMgr.remove(cronTaskId, cronTaskHistoryId);
                                try {
                                    Util.logLink((String)(taskKey + " > completed: " + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]))).log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)jobLog).log(arg_0));
                                    jobLog.flush();
                                    jobLog.close();
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        }));
                        jobContext.setFuture(future);
                        Util.logLink((String)("OK, the task is scheduled: " + taskKey)).log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
                        taskSubmitResponse.setSubmitted(true);
                        JobEndpoint.this.jobInnerContextMgr.add(cronTaskId, cronTaskHistoryId, jobContext);
                    }
                    catch (RejectedExecutionException e) {
                        taskSubmitResponse.setSubmitted(false);
                        taskSubmitResponse.setDesc("Rejected, resource is unavailable ");
                        Util.logLink((String)"Rejected, resource is unavailable ").log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
                        throw Util.convert2RuntimeException((Throwable)e);
                    }
                    return null;
                }
            }, (long)15L, (TimeUnit)TimeUnit.SECONDS);
            return taskSubmitResponse;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            logBeforeSubmitted.flush();
            Util.errorStackList((Throwable)e).forEach(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
            logBeforeSubmitted.flush();
            return taskSubmitResponse;
        }
        finally {
            try {
                logBeforeSubmitted.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                MDC.remove((String)"traceId");
                MDC.remove((String)"requestId");
            }
        }
    }

    @RequestMapping(value={"/capture"})
    @ResponseBody
    public JobCaptureResponse capture(@RequestBody JobCaptureRequest jobCaptureRequest) {
        JobCaptureResponse jobCaptureResponse = new JobCaptureResponse();
        jobCaptureResponse.setSuccess(true);
        long cronTaskId = jobCaptureRequest.getCronTaskId();
        long cronTaskHistoryId = jobCaptureRequest.getCronTaskHistoryId();
        JobContextImpl jobContext = (JobContextImpl)this.jobInnerContextMgr.jobInnerContext(cronTaskId, cronTaskHistoryId);
        jobCaptureResponse.setAllTaskCountInNode(this.jobInnerContextMgr.count());
        jobCaptureResponse.setFound(false);
        if (jobContext == null) {
            return jobCaptureResponse;
        }
        jobCaptureResponse.setFound(true);
        jobCaptureResponse.setCronTaskId(cronTaskId);
        jobCaptureResponse.setCronTaskHistoryId(cronTaskHistoryId);
        jobCaptureResponse.setStartTime(jobContext.getStartTime());
        jobCaptureResponse.setStartTimeStr(Util.formatTime((LocalDateTime)Util.dateTime((long)jobContext.getStartTime()), (String[])new String[0]));
        if (jobCaptureRequest.isCaptureStack()) {
            Thread ioThread = jobContext.getIoThread();
            StackTraceElement[] stackTraceElements = ioThread.getStackTrace();
            ArrayList<String> stackList = new ArrayList<String>(stackTraceElements.length);
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                stackList.add(stackTraceElement.toString());
            }
            jobCaptureResponse.setIoThread(ioThread.getName());
            jobCaptureResponse.setIoStackList(stackList);
        }
        return jobCaptureResponse;
    }

    @OnlyPrivate
    public static class JobContextImpl
    implements JobContext,
    JobInnerContext {
        final TaskSubmitRequest taskSubmitRequest;
        final JobService jobService;
        private long cronTaskId;
        private long cronTaskHistoryId;
        private Future<?> future;
        private boolean killed;
        @JsonIgnore
        private transient Thread ioThread;
        private final long startTime = System.currentTimeMillis();

        public JobContextImpl(TaskSubmitRequest taskSubmitRequest, JobService jobService) {
            this.taskSubmitRequest = taskSubmitRequest;
            this.jobService = jobService;
        }

        public Long jobId() {
            return this.taskSubmitRequest.getCronTaskId();
        }

        public String name() {
            return this.taskSubmitRequest.getName();
        }

        public String uri() {
            return this.taskSubmitRequest.getUri();
        }

        public String args() {
            return this.taskSubmitRequest.getArgs();
        }

        public String jobIdInES() {
            return this.taskSubmitRequest.getJobIdInES();
        }

        public JobService jobService() {
            return this.jobService;
        }

        public boolean isCancelled() {
            return false;
        }

        public void heartbeatData(Object data) {
        }

        public long cronTaskId() {
            return this.cronTaskId;
        }

        public long cronTaskHistoryId() {
            return this.cronTaskHistoryId;
        }

        public Future<?> future() {
            return this.future;
        }

        public boolean killed() {
            return this.killed;
        }

        public Thread ioThread() {
            return this.ioThread;
        }

        public TaskSubmitRequest getTaskSubmitRequest() {
            return this.taskSubmitRequest;
        }

        public JobService getJobService() {
            return this.jobService;
        }

        public long getCronTaskId() {
            return this.cronTaskId;
        }

        public long getCronTaskHistoryId() {
            return this.cronTaskHistoryId;
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public boolean isKilled() {
            return this.killed;
        }

        public Thread getIoThread() {
            return this.ioThread;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setCronTaskId(long cronTaskId) {
            this.cronTaskId = cronTaskId;
        }

        public void setCronTaskHistoryId(long cronTaskHistoryId) {
            this.cronTaskHistoryId = cronTaskHistoryId;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        public void setKilled(boolean killed) {
            this.killed = killed;
        }

        @JsonIgnore
        public void setIoThread(Thread ioThread) {
            this.ioThread = ioThread;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobContextImpl)) {
                return false;
            }
            JobContextImpl other = (JobContextImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCronTaskId() != other.getCronTaskId()) {
                return false;
            }
            if (this.getCronTaskHistoryId() != other.getCronTaskHistoryId()) {
                return false;
            }
            if (this.isKilled() != other.isKilled()) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            TaskSubmitRequest this$taskSubmitRequest = this.getTaskSubmitRequest();
            TaskSubmitRequest other$taskSubmitRequest = other.getTaskSubmitRequest();
            if (this$taskSubmitRequest == null ? other$taskSubmitRequest != null : !this$taskSubmitRequest.equals(other$taskSubmitRequest)) {
                return false;
            }
            JobService this$jobService = this.getJobService();
            JobService other$jobService = other.getJobService();
            if (this$jobService == null ? other$jobService != null : !this$jobService.equals(other$jobService)) {
                return false;
            }
            Future<?> this$future = this.getFuture();
            Future<?> other$future = other.getFuture();
            return !(this$future == null ? other$future != null : !this$future.equals(other$future));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobContextImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $cronTaskId = this.getCronTaskId();
            result = result * 59 + (int)($cronTaskId >>> 32 ^ $cronTaskId);
            long $cronTaskHistoryId = this.getCronTaskHistoryId();
            result = result * 59 + (int)($cronTaskHistoryId >>> 32 ^ $cronTaskHistoryId);
            result = result * 59 + (this.isKilled() ? 79 : 97);
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            TaskSubmitRequest $taskSubmitRequest = this.getTaskSubmitRequest();
            result = result * 59 + ($taskSubmitRequest == null ? 43 : $taskSubmitRequest.hashCode());
            JobService $jobService = this.getJobService();
            result = result * 59 + ($jobService == null ? 43 : $jobService.hashCode());
            Future<?> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            return result;
        }

        public String toString() {
            return "JobEndpoint.JobContextImpl(taskSubmitRequest=" + this.getTaskSubmitRequest() + ", jobService=" + this.getJobService() + ", cronTaskId=" + this.getCronTaskId() + ", cronTaskHistoryId=" + this.getCronTaskHistoryId() + ", future=" + this.getFuture() + ", killed=" + this.isKilled() + ", ioThread=" + this.getIoThread() + ", startTime=" + this.getStartTime() + ")";
        }
    }
}

