/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.ClientJobConfig;
import com.ovopark.jobhub.sdk.client.ClientNodeProvider;
import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.kernel.shared.NetUtil;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vclient.ClientNode;
import java.net.InetAddress;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;

@JobClientActive
@Component(value="com.ovopark.jobhub.sdk.client.NacosNodeProvider")
public class NacosNodeProvider
implements ClientNodeProvider {
    @Autowired
    private ServiceInstance serviceInstance;
    @Autowired
    private ClientJobConfig clientJobConfig;
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    @Value(value="${JOBHUB_CLIENT_APP:${spring.application.name}}")
    private String app;

    public ClientNode clientNode() {
        int port;
        URI uri = this.serviceInstance.getUri();
        String registerIp = this.clientJobConfig.getIp();
        if (Util.isEmpty((CharSequence)registerIp)) {
            if (this.clientJobConfig.isUseNacosIp()) {
                registerIp = uri.getHost();
            } else {
                InetAddress localAddress = NetUtil.getLocalAddress();
                registerIp = localAddress.getHostAddress();
            }
        }
        if (Util.isEmpty((CharSequence)registerIp)) {
            Util.log.error("cannot find right IP , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }
        if ((port = this.clientJobConfig.getPort() > 0 ? this.clientJobConfig.getPort() : uri.getPort()) <= 0) {
            Util.log.error("cannot find port , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }
        ClientNode.ClientNodeImpl node = new ClientNode.ClientNodeImpl();
        node.setNode(ClientNode.UUID_STR);
        node.setIp(registerIp);
        node.setPort(port);
        node.setServletPath(this.contextPath);
        node.setApp(this.app);
        return node;
    }
}

