package com.ovopark.knife.client.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Created by xuxing on 2019/9/10
 * 开放平台注册中心配置
 */
@ConfigurationProperties(prefix = "open.api")
public class OpenPlatformApiProperties {
  // 是否启用
  private Boolean enable = false;
  //注册中心地址
  private String registerUrl;
  // 控制扫描包路径
  private String scanPackage;
  // 服务名称，默认取spring.application.name\dubbo.application.name
  private String applicationName;
  // 默认取dubbo.registry.address,如果不是本服务器需要配置
  private String zkAddress;

  public Boolean getEnable() {
    return enable;
  }

  public void setEnable(Boolean enable) {
    this.enable = enable;
  }

  public String getRegisterUrl() {
    return registerUrl;
  }

  public void setRegisterUrl(String registerUrl) {
    this.registerUrl = registerUrl;
  }

  public String getScanPackage() {
    return scanPackage;
  }

  public void setScanPackage(String scanPackage) {
    this.scanPackage = scanPackage;
  }

  public String getApplicationName() {
    return applicationName;
  }

  public void setApplicationName(String applicationName) {
    this.applicationName = applicationName;
  }

  public String getZkAddress() {
    return zkAddress;
  }

  public void setZkAddress(String zkAddress) {
    this.zkAddress = zkAddress;
  }
}
