/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.knife.client.register;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.boot.kit.http.HttpClientKit;
import com.ovopark.boot.kit.lang.StrKit;
import com.ovopark.knife.client.properties.OpenPlatformApiProperties;
import com.ovopark.knife.common.annotation.OpenPlatformApi;
import com.ovopark.knife.common.model.RegisterInfo;
import com.ovopark.knife.common.utils.IPKit;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Resource;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterNamesScanner;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={OpenPlatformApiProperties.class})
public class RegisterHandler {
    Logger log = LoggerFactory.getLogger(RegisterHandler.class);
    static final String OpenMethod = "api.method";
    @Resource
    private OpenPlatformApiProperties openPlatformApiProperties;
    @Resource
    private Environment env;

    @Bean
    @Order(value=99)
    public OpenPlatformApiProperties register() {
        try {
            String appName;
            if (!this.openPlatformApiProperties.getEnable().booleanValue()) {
                return this.openPlatformApiProperties;
            }
            if (StrKit.isEmpty((String)this.openPlatformApiProperties.getRegisterUrl())) {
                throw new RuntimeException("register centre url is null");
            }
            String string = StrKit.isNotEmpty((String)this.openPlatformApiProperties.getApplicationName()) ? this.openPlatformApiProperties.getApplicationName() : (appName = StrKit.isNotEmpty((String)this.env.getProperty("spring.application.name")) ? this.env.getProperty("spring.application.name") : this.env.getProperty("dubbo.application.name"));
            if (StrKit.isEmpty((String)appName)) {
                throw new RuntimeException("application name is null");
            }
            String zkaddress = StrKit.isNotEmpty((String)this.openPlatformApiProperties.getZkAddress()) ? this.openPlatformApiProperties.getZkAddress() : this.env.getProperty("dubbo.registry.address");
            Reflections reflections = new Reflections(this.openPlatformApiProperties.getScanPackage(), new Scanner[]{new MethodAnnotationsScanner(), new MethodParameterNamesScanner()});
            Set methodsAnnotatedWith = reflections.getMethodsAnnotatedWith(OpenPlatformApi.class);
            String environment = this.env.getProperty("spring.profiles.active");
            HashMap<String, String> routeUrlMap = new HashMap<String, String>();
            HashMap<String, String> dubboRouteUrlMap = new HashMap<String, String>();
            for (Method method : methodsAnnotatedWith) {
                OpenPlatformApi annotation = method.getAnnotation(OpenPlatformApi.class);
                String interfaceName = method.getDeclaringClass().getName();
                String methodName = method.getName();
                dubboRouteUrlMap.put(RegisterHandler.createRouteKey(annotation.mt(), annotation.version().getKey()), interfaceName + "-" + methodName);
                routeUrlMap.put(RegisterHandler.createRouteKey(annotation.mt(), annotation.version().getKey()), annotation.route());
                this.log.info("method name = {} ;route = {} ;mt = {}", new Object[]{methodName, annotation.route(), annotation.mt()});
            }
            RegisterInfo registerInfo = new RegisterInfo();
            registerInfo.setApplicationName(appName);
            registerInfo.setRouteUrlMap(routeUrlMap);
            registerInfo.setZkAddress(zkaddress);
            registerInfo.setEnv(environment);
            registerInfo.setRouteDubboMap(dubboRouteUrlMap);
            registerInfo.setIp(IPKit.getV4IP() + "/" + IPKit.getInnetIp() + ":" + this.env.getProperty("server.port"));
            String result = HttpClientKit.init().doPostJson(this.openPlatformApiProperties.getRegisterUrl(), JSONObject.toJSON((Object)registerInfo));
            if (!"success".equals(result)) {
                throw new RuntimeException("Registration to " + this.openPlatformApiProperties.getRegisterUrl() + " failed !!!!");
            }
            this.log.info("Registration successfully to {} !!!!", (Object)this.openPlatformApiProperties.getRegisterUrl());
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return this.openPlatformApiProperties;
    }

    private static String createRouteKey(String method, String version) {
        return "api.method-" + version + "-" + method;
    }
}

