package com.ovopark.knife.common.annotation;

import com.ovopark.knife.common.em.GwType;
import com.ovopark.knife.common.em.GwVersion;

import java.lang.annotation.*;

@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface OpenPlatformApi {
    /**
     * @Title: mt   
     * @Description: TODO(对应报文头参数_mt-接口名称)   
     * @param: @return      
     * @return: String      
     * @throws
     */
    String mt();
    /**
     * @Title: route   
     * @Description: TODO(路由地址)   
     * @param: @return      
     * @return: String      
     * @throws
     */
    String route() default "";
    /**
     * @Title: gwtype   
     * @Description: TODO(网关类型)   
     * @param: @return      
     * @return: GwType      
     * @throws
     */
    GwType gwtype() default GwType.OPEN;
     
    GwVersion version() default GwVersion.v1;
}
