package com.ovopark.knife.common.comm;

import java.nio.charset.Charset;

/**
    * @ClassName: ConstField
    * @Description: TODO(常量字段)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年9月17日 下午5:10:02
 */
public class ConstField {
    public static final Charset UTF8                 = Charset.forName("utf-8");
    public static final Charset ASCII                = Charset.forName("ascii");
    public static final byte[]  XML_START            = "<xml>".getBytes(UTF8);
    public static final byte[]  XML_END              = "</xml>".getBytes(UTF8);
    public static final byte[]  JSON_START           = "{\"stat\":".getBytes(UTF8);
    public static final byte[]  JSON_CONTENT         = ",\"result\":[".getBytes(UTF8);
    public static final byte[]  XML_EMPTY            = "<empty/>".getBytes(ConstField.UTF8);
    public static final byte[]  JSON_SPLIT           = ",".getBytes(UTF8);
    public static final byte[]  JSON_END             = "]}".getBytes(UTF8);
    public static final byte[]  JSON_EMPTY           = "{}".getBytes(UTF8);
    public static final byte[]  JSONP_START          = "(".getBytes(UTF8);
    public static final byte[]  JSONP_END            = ");".getBytes(UTF8);
    
    public static final String DEV="dev";
	public static final String TEST="test";
	public static final String FORMAL="formal";
	
	public abstract class ContentTypeConst{
		public static final String COMMON="common";
		public static final String MULTIPART="multipart";
		public static final String JSON="json";
		public static final String TEXT="text";
	}
}
