/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

@RefreshScope
@Configuration
@ConfigurationProperties(value="messagehub.shared")
public class MsgHubSharedConfig {
    private int maxFrom = 10000;
    private int maxPageSize = 1000;
    private int msgCfgExpiredSec = 3600;
    private int msgCfgLocalExpiredSec = 15;
    private int msgGroupExpiredSec = 3600;
    private int todoMsgGroupViewExpiredSec = 3600;
    private boolean fsyncMsgType = true;
    private int msgUpdatedPushSec = 60;
    private int msgCreatedPushSec = 60;
    private int todoMsgEventPushSec = 1;
    private int todoMsgCountPushSec = 3;
    private boolean verbose;
    private String shutdownToken = "shutdownToken";
    private String ip;
    private int port;
    private boolean useNacosIp = true;
    private int todoMsgCreateTimeHour = 12;
    private int searchableDays = 30;
    private int maxSearchableIndexCount = 10;
    private boolean usePositionFilter = true;
    private boolean interactEnabled = false;

    public int getMaxFrom() {
        return this.maxFrom;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getMsgCfgExpiredSec() {
        return this.msgCfgExpiredSec;
    }

    public int getMsgCfgLocalExpiredSec() {
        return this.msgCfgLocalExpiredSec;
    }

    public int getMsgGroupExpiredSec() {
        return this.msgGroupExpiredSec;
    }

    public int getTodoMsgGroupViewExpiredSec() {
        return this.todoMsgGroupViewExpiredSec;
    }

    public boolean isFsyncMsgType() {
        return this.fsyncMsgType;
    }

    public int getMsgUpdatedPushSec() {
        return this.msgUpdatedPushSec;
    }

    public int getMsgCreatedPushSec() {
        return this.msgCreatedPushSec;
    }

    public int getTodoMsgEventPushSec() {
        return this.todoMsgEventPushSec;
    }

    public int getTodoMsgCountPushSec() {
        return this.todoMsgCountPushSec;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getShutdownToken() {
        return this.shutdownToken;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isUseNacosIp() {
        return this.useNacosIp;
    }

    public int getTodoMsgCreateTimeHour() {
        return this.todoMsgCreateTimeHour;
    }

    public int getSearchableDays() {
        return this.searchableDays;
    }

    public int getMaxSearchableIndexCount() {
        return this.maxSearchableIndexCount;
    }

    public boolean isUsePositionFilter() {
        return this.usePositionFilter;
    }

    public boolean isInteractEnabled() {
        return this.interactEnabled;
    }

    public void setMaxFrom(int maxFrom) {
        this.maxFrom = maxFrom;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public void setMsgCfgExpiredSec(int msgCfgExpiredSec) {
        this.msgCfgExpiredSec = msgCfgExpiredSec;
    }

    public void setMsgCfgLocalExpiredSec(int msgCfgLocalExpiredSec) {
        this.msgCfgLocalExpiredSec = msgCfgLocalExpiredSec;
    }

    public void setMsgGroupExpiredSec(int msgGroupExpiredSec) {
        this.msgGroupExpiredSec = msgGroupExpiredSec;
    }

    public void setTodoMsgGroupViewExpiredSec(int todoMsgGroupViewExpiredSec) {
        this.todoMsgGroupViewExpiredSec = todoMsgGroupViewExpiredSec;
    }

    public void setFsyncMsgType(boolean fsyncMsgType) {
        this.fsyncMsgType = fsyncMsgType;
    }

    public void setMsgUpdatedPushSec(int msgUpdatedPushSec) {
        this.msgUpdatedPushSec = msgUpdatedPushSec;
    }

    public void setMsgCreatedPushSec(int msgCreatedPushSec) {
        this.msgCreatedPushSec = msgCreatedPushSec;
    }

    public void setTodoMsgEventPushSec(int todoMsgEventPushSec) {
        this.todoMsgEventPushSec = todoMsgEventPushSec;
    }

    public void setTodoMsgCountPushSec(int todoMsgCountPushSec) {
        this.todoMsgCountPushSec = todoMsgCountPushSec;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setShutdownToken(String shutdownToken) {
        this.shutdownToken = shutdownToken;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUseNacosIp(boolean useNacosIp) {
        this.useNacosIp = useNacosIp;
    }

    public void setTodoMsgCreateTimeHour(int todoMsgCreateTimeHour) {
        this.todoMsgCreateTimeHour = todoMsgCreateTimeHour;
    }

    public void setSearchableDays(int searchableDays) {
        this.searchableDays = searchableDays;
    }

    public void setMaxSearchableIndexCount(int maxSearchableIndexCount) {
        this.maxSearchableIndexCount = maxSearchableIndexCount;
    }

    public void setUsePositionFilter(boolean usePositionFilter) {
        this.usePositionFilter = usePositionFilter;
    }

    public void setInteractEnabled(boolean interactEnabled) {
        this.interactEnabled = interactEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsgHubSharedConfig)) {
            return false;
        }
        MsgHubSharedConfig other = (MsgHubSharedConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxFrom() != other.getMaxFrom()) {
            return false;
        }
        if (this.getMaxPageSize() != other.getMaxPageSize()) {
            return false;
        }
        if (this.getMsgCfgExpiredSec() != other.getMsgCfgExpiredSec()) {
            return false;
        }
        if (this.getMsgCfgLocalExpiredSec() != other.getMsgCfgLocalExpiredSec()) {
            return false;
        }
        if (this.getMsgGroupExpiredSec() != other.getMsgGroupExpiredSec()) {
            return false;
        }
        if (this.getTodoMsgGroupViewExpiredSec() != other.getTodoMsgGroupViewExpiredSec()) {
            return false;
        }
        if (this.isFsyncMsgType() != other.isFsyncMsgType()) {
            return false;
        }
        if (this.getMsgUpdatedPushSec() != other.getMsgUpdatedPushSec()) {
            return false;
        }
        if (this.getMsgCreatedPushSec() != other.getMsgCreatedPushSec()) {
            return false;
        }
        if (this.getTodoMsgEventPushSec() != other.getTodoMsgEventPushSec()) {
            return false;
        }
        if (this.getTodoMsgCountPushSec() != other.getTodoMsgCountPushSec()) {
            return false;
        }
        if (this.isVerbose() != other.isVerbose()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isUseNacosIp() != other.isUseNacosIp()) {
            return false;
        }
        if (this.getTodoMsgCreateTimeHour() != other.getTodoMsgCreateTimeHour()) {
            return false;
        }
        if (this.getSearchableDays() != other.getSearchableDays()) {
            return false;
        }
        if (this.getMaxSearchableIndexCount() != other.getMaxSearchableIndexCount()) {
            return false;
        }
        if (this.isUsePositionFilter() != other.isUsePositionFilter()) {
            return false;
        }
        if (this.isInteractEnabled() != other.isInteractEnabled()) {
            return false;
        }
        String this$shutdownToken = this.getShutdownToken();
        String other$shutdownToken = other.getShutdownToken();
        if (this$shutdownToken == null ? other$shutdownToken != null : !this$shutdownToken.equals(other$shutdownToken)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MsgHubSharedConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxFrom();
        result = result * 59 + this.getMaxPageSize();
        result = result * 59 + this.getMsgCfgExpiredSec();
        result = result * 59 + this.getMsgCfgLocalExpiredSec();
        result = result * 59 + this.getMsgGroupExpiredSec();
        result = result * 59 + this.getTodoMsgGroupViewExpiredSec();
        result = result * 59 + (this.isFsyncMsgType() ? 79 : 97);
        result = result * 59 + this.getMsgUpdatedPushSec();
        result = result * 59 + this.getMsgCreatedPushSec();
        result = result * 59 + this.getTodoMsgEventPushSec();
        result = result * 59 + this.getTodoMsgCountPushSec();
        result = result * 59 + (this.isVerbose() ? 79 : 97);
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isUseNacosIp() ? 79 : 97);
        result = result * 59 + this.getTodoMsgCreateTimeHour();
        result = result * 59 + this.getSearchableDays();
        result = result * 59 + this.getMaxSearchableIndexCount();
        result = result * 59 + (this.isUsePositionFilter() ? 79 : 97);
        result = result * 59 + (this.isInteractEnabled() ? 79 : 97);
        String $shutdownToken = this.getShutdownToken();
        result = result * 59 + ($shutdownToken == null ? 43 : $shutdownToken.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        return result;
    }

    public String toString() {
        return "MsgHubSharedConfig(maxFrom=" + this.getMaxFrom() + ", maxPageSize=" + this.getMaxPageSize() + ", msgCfgExpiredSec=" + this.getMsgCfgExpiredSec() + ", msgCfgLocalExpiredSec=" + this.getMsgCfgLocalExpiredSec() + ", msgGroupExpiredSec=" + this.getMsgGroupExpiredSec() + ", todoMsgGroupViewExpiredSec=" + this.getTodoMsgGroupViewExpiredSec() + ", fsyncMsgType=" + this.isFsyncMsgType() + ", msgUpdatedPushSec=" + this.getMsgUpdatedPushSec() + ", msgCreatedPushSec=" + this.getMsgCreatedPushSec() + ", todoMsgEventPushSec=" + this.getTodoMsgEventPushSec() + ", todoMsgCountPushSec=" + this.getTodoMsgCountPushSec() + ", verbose=" + this.isVerbose() + ", shutdownToken=" + this.getShutdownToken() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", useNacosIp=" + this.isUseNacosIp() + ", todoMsgCreateTimeHour=" + this.getTodoMsgCreateTimeHour() + ", searchableDays=" + this.getSearchableDays() + ", maxSearchableIndexCount=" + this.getMaxSearchableIndexCount() + ", usePositionFilter=" + this.isUsePositionFilter() + ", interactEnabled=" + this.isInteractEnabled() + ")";
    }
}

