/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.rpc;

import com.ovopark.messagehub.kernel.rpc.RPCService;
import com.ovopark.module.shared.RPCResult;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.common.model.mo.SimpleUserMo;
import com.ovopark.organize.common.model.mo.SystemConfigureMo;
import com.ovopark.organize.common.model.pojo.BusinessTimePojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.common.model.pojo.UserPagePojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.SysApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RPCServiceImpl
implements RPCService {
    @Resource
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Resource
    private DepartmentApi departmentApi;
    @Autowired
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private com.ovopark.privilege.api.UserApi userApi;
    @Autowired
    private UserApi orgUserApi;
    @Autowired
    private UserApi userApiOrganize;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private OrganizeApi organizeApi;
    @Autowired
    private SysApi sysApi;

    @Override
    public EnterpriseConfigPojo enterpriseConfig(Integer enterpriseId) {
        com.ovopark.organize.common.base.BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfig(enterpriseId);
        if (!result.getIsError().booleanValue()) {
            return (EnterpriseConfigPojo)result.getData();
        }
        return null;
    }

    @Override
    public EnterpriseGroupMo enterprise(Integer enterpriseId) {
        com.ovopark.organize.common.base.BaseResult result = this.enterpriseGroupsApi.getEnterpriseByGroupIdApi(enterpriseId);
        if (!result.getIsError().booleanValue()) {
            return (EnterpriseGroupMo)result.getData();
        }
        return null;
    }

    @Override
    public List<EnterpriseGroupMo> enterpriseList(List<Integer> enterpriseId) {
        com.ovopark.organize.common.base.BaseResult result = this.enterpriseGroupsApi.getEnterpriseByIdsApi(enterpriseId);
        if (!result.getIsError().booleanValue()) {
            return (List)result.getData();
        }
        return null;
    }

    @Override
    public DepartmentPojo department(Integer depId) {
        com.ovopark.organize.common.base.BaseResult result = this.departmentApi.getDepartmentById(depId);
        if (!result.getIsError().booleanValue()) {
            return (DepartmentPojo)result.getData();
        }
        return null;
    }

    @Override
    public List<Integer> getDepIdsByEnterpriseId(Integer enterpriseId) {
        com.ovopark.organize.common.base.BaseResult result = this.departmentApi.getDepIdsByEnterpriseId(enterpriseId);
        if (!result.getIsError().booleanValue()) {
            return (List)result.getData();
        }
        return null;
    }

    @Override
    public List<DepartmentPojo> departmentList(List<Integer> depId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.departmentApi.getDepartmentByIds(depId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public BusinessTimePojo businessTimeByDate(Integer deptId, String date) {
        com.ovopark.organize.common.base.BaseResult result = this.departmentApi.getBusinessTimeByDate(deptId, date);
        if (!result.getIsError().booleanValue()) {
            return (BusinessTimePojo)result.getData();
        }
        return null;
    }

    @Override
    public List<RolePojo> getRolesByUser(Integer userId, Integer enterpriseId) {
        BaseResult baseResult = this.roleApi.getRolesByUser(userId, enterpriseId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public Map<Integer, List<RolePojo>> batchGetUserRoleList(List<Integer> userId) {
        BaseResult baseResult = this.roleApi.batchGetUserRoleList(userId);
        if (!baseResult.getIsError().booleanValue()) {
            return (Map)baseResult.getData();
        }
        return null;
    }

    @Override
    public com.ovopark.organize.common.model.pojo.UsersPojo userList(Integer userId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApiOrganize.getUserById(userId);
        if (!baseResult.getIsError().booleanValue()) {
            return (com.ovopark.organize.common.model.pojo.UsersPojo)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<com.ovopark.organize.common.model.pojo.UsersPojo> userList(List<Integer> userId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApiOrganize.getUserByIdList(userId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<Integer> getAllChildUser(Integer userId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApiOrganize.getAllChildUser(userId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<SimpleUserMo> getMailListUsersByUser(Integer enterpriseId, Integer userId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userOrganizeApi.getMailListUsersByUser(enterpriseId, userId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<com.ovopark.organize.common.model.pojo.UsersPojo> getAuthorizedUser() {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApiOrganize.getSpecialUser();
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public boolean isSuperAdmin(Integer enterpriseId, Integer userId) {
        BaseResult baseResult = this.userApi.isSuperAdmin(userId, enterpriseId);
        if (!baseResult.getIsError().booleanValue()) {
            return baseResult.getData() == null ? false : (Boolean)baseResult.getData();
        }
        return false;
    }

    @Override
    public List<EnterpriseGroupMo> getEnterpriseByCreateId(Integer userId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.enterpriseGroupsApi.getEnterpriseByCreateId(userId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<Integer> getPrivilegeDepIdByUserIdAndGroupId(Integer userId, Integer groupId, Boolean filterClosedShops) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userDepPrivilegeApi.getPrivilegeDepIdByUserIdAndGroupId(userId, groupId, filterClosedShops);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public UsersPojo getUsersById(Integer userId) {
        BaseResult baseResult = this.userApi.getUsersById(userId);
        if (!baseResult.getIsError().booleanValue()) {
            return (UsersPojo)baseResult.getData();
        }
        return null;
    }

    @Override
    public Map<Integer, List<RolePojo>> getUserRoleList(Map<String, Object> params) {
        BaseResult baseResult = this.roleApi.getUserRoleList(params);
        if (!baseResult.getIsError().booleanValue()) {
            return (Map)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<Integer> searchChildIdsSdk(Integer userId, Integer showFrozen) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.orgUserApi.searchChildIdsSdk(userId, showFrozen);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<Integer> findAllChildOrganizeids(Integer organizeId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.organizeApi.findAllChildOrganizeids(organizeId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<Integer> searchUserIdsByOrganize(List<Integer> organizeIds, Integer showFrozen) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.organizeApi.searchUserIdsByOrganize(organizeIds, showFrozen);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<Integer> filterHiddenUser(List<Integer> userIds) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApiOrganize.filterHiddenUser(userIds);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<UsersPojo> getUserByRoleIds(String roleIds, Integer groupId) {
        BaseResult baseResult = this.userApi.getUserByRoleIds(roleIds, groupId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<UsersPojo> getAllUserByRoleIds(String roleIds, Integer groupId) {
        BaseResult baseResult = this.userApi.getAllUserByRoleIds(roleIds, groupId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<Integer> getSortedUserIds(List<Integer> unLoginUserIds) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApiOrganize.getSortedUserIds(unLoginUserIds);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getUserInfo(List<Integer> userIds, Integer enterpriseId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApiOrganize.getUserInfo(userIds, enterpriseId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<com.ovopark.organize.common.model.pojo.UsersPojo> getChildUserByUserIdAndGroupId(Integer userId) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApiOrganize.getChildUserByUserIdAndGroupId(userId);
        if (!baseResult.getIsError().booleanValue()) {
            return (List)baseResult.getData();
        }
        return null;
    }

    @Override
    public Map<String, Object> getUserPageList(UserPagePojo userPagePojo) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.userApiOrganize.getUserPageList(userPagePojo);
        if (!baseResult.getIsError().booleanValue()) {
            return (Map)baseResult.getData();
        }
        return null;
    }

    @Override
    public List<com.ovopark.organize.common.model.pojo.UsersPojo> getUserByIdList(List<Integer> userIdList) {
        com.ovopark.organize.common.base.BaseResult result = this.userApiOrganize.getUserByIdList(userIdList);
        if (!result.getIsError().booleanValue()) {
            return (List)result.getData();
        }
        return null;
    }

    @Override
    public SystemConfigureMo getSystemConfigureByGroupId(Integer groupId, String groupCorpId, Integer systemType) {
        com.ovopark.organize.common.base.BaseResult baseResult = this.sysApi.getSystemConfigureByGroupId(groupId, groupCorpId, systemType);
        if (baseResult != null && !baseResult.getIsError().booleanValue()) {
            return (SystemConfigureMo)baseResult.getData();
        }
        return null;
    }

    private static class RPCResultImpl
    implements RPCResult {
        private final boolean success;
        private String message;

        public RPCResultImpl(boolean success) {
            this.success = success;
        }

        public boolean success() {
            return this.success;
        }

        public String message() {
            return this.message;
        }

        static RPCResultImpl newSuccess() {
            RPCResultImpl rpcResult = new RPCResultImpl(true);
            return rpcResult;
        }

        static RPCResultImpl newFail(String message) {
            RPCResultImpl rpcResult = new RPCResultImpl(false);
            rpcResult.setMessage(message);
            return rpcResult;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

