/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.messagehub.kernel.DefMsgCfService;
import com.ovopark.messagehub.kernel.DefMsgMappingConfig;
import com.ovopark.messagehub.kernel.mapper.CfgMapper;
import com.ovopark.messagehub.kernel.mapper.MessagePushTemplateMapper;
import com.ovopark.messagehub.kernel.mapper.MessageTypeHistoryMapper;
import com.ovopark.messagehub.kernel.mapper.MessageTypeMapper;
import com.ovopark.messagehub.kernel.mapper.MessageTypeVsPushTemplateMapper;
import com.ovopark.messagehub.kernel.model.entity.Cfg;
import com.ovopark.messagehub.kernel.model.entity.MessagePushTemplate;
import com.ovopark.messagehub.kernel.model.entity.MessageType;
import com.ovopark.messagehub.kernel.model.entity.MessageTypeHistory;
import com.ovopark.messagehub.kernel.model.entity.MessageTypeVsPushTemplate;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.module.shared.SharedLocale;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DefMsgCfServiceImpl
implements DefMsgCfService {
    private static final Logger log = LoggerFactory.getLogger(DefMsgCfServiceImpl.class);
    private static final Locale[] LOCALES = new Locale[]{Locale.CHINA, Locale.US, Locale.TAIWAN, SharedLocale.IN_ID, Locale.JAPAN, Locale.ITALY};
    static final CacheService<String, DefMsgCfService.DefMsgCf> MTC = new CacheService.MapCacheService();
    static volatile List<DefMsgCfService.DefMsgCfNode> defMsgCfNodeList;
    static volatile List<String> msgTypeCodeList;
    @Autowired
    private DefMsgMappingConfig defMsgMappingConfig;
    static final int startOrderIndex = 1;
    @Autowired
    private MessageTypeMapper messageTypeMapper;
    @Autowired
    private MessagePushTemplateMapper messagePushTemplateMapper;
    @Autowired
    MessageTypeVsPushTemplateMapper messageTypeVsPushTemplateMapper;
    @Autowired
    private MessageTypeHistoryMapper messageTypeHistoryMapper;
    @Autowired
    private CfgMapper cfgMapper;
    @Autowired
    private MessageSource messageSource;

    @PostConstruct
    private void post() throws IOException {
        try {
            this.post0();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            log.error("jvm exit, : cannot load message type tree");
            Runtime.getRuntime().exit(-1);
        }
    }

    private void post0() {
        int currentVer = -1;
        ArrayList<DefMsgCfService.DefMsgCf> all = new ArrayList<DefMsgCfService.DefMsgCf>();
        Map<String, Map<String, Object>> msgTree = this.defMsgMappingConfig.getMsgTree();
        for (Map.Entry<String, Map<String, Object>> level1Entry : msgTree.entrySet()) {
            Map<String, Object> level1Map = level1Entry.getValue();
            if (Util.compare2((Comparable)((Integer)level1Map.get("delete")), (Comparable)Integer.valueOf(1)) == 0) continue;
            String level1Key = level1Entry.getKey();
            String level1Name = (String)level1Map.get("name");
            String level1AppRole = (String)level1Map.get("appRole");
            String level1WebRole = (String)level1Map.get("webRole");
            DefMsgCfService.DefMsgCf level1DefMsgCf = new DefMsgCfService.DefMsgCf();
            level1DefMsgCf.setVer(this.defMsgMappingConfig.getVer());
            level1DefMsgCf.setCode(level1Key);
            level1DefMsgCf.setName(level1Name);
            level1DefMsgCf.setOrder((Integer)level1Map.get("order"));
            if (Util.isNotEmpty((CharSequence)level1AppRole)) {
                level1DefMsgCf.setAppRoleList(Set.of(level1AppRole.split(",")));
            }
            if (Util.isNotEmpty((CharSequence)level1WebRole)) {
                level1DefMsgCf.setWebRoleList(Set.of(level1WebRole.split(",")));
            }
            level1DefMsgCf.setLocaleMap(this.localeMap(level1Key, level1Name, level1Map));
            level1DefMsgCf.setAppSysNotify(1);
            level1DefMsgCf.setUseJg(1);
            level1DefMsgCf.setUseMail(1);
            level1DefMsgCf.setUseSms(1);
            level1DefMsgCf.setUseWebSocket(1);
            level1DefMsgCf.setPop(1);
            level1DefMsgCf.setFloatWindow(1);
            level1DefMsgCf.setTopWindow(1);
            level1DefMsgCf.setUseQiWei(1);
            level1DefMsgCf.setUseDingDing(1);
            level1DefMsgCf.setUseFeiShu(1);
            level1DefMsgCf.setUseWeiXin(1);
            int i = this.defMsgMappingConfig.getOrder().indexOf(level1Key);
            if (i == -1) {
                throw new RuntimeException("message type order is missing???: " + level1Key);
            }
            level1DefMsgCf.setMessageTypeOrderId(i + 1);
            all.add(level1DefMsgCf);
            Map level2 = (Map)level1Map.get("child");
            if (level2 == null) continue;
            for (Map.Entry level2Entry : level2.entrySet()) {
                String level2Key = (String)level2Entry.getKey();
                Map level2Map = (Map)level2Entry.getValue();
                String level2Name = (String)level2Map.get("name");
                String level2AppRole = (String)level2Map.get("appRole");
                String level2WebRole = (String)level2Map.get("webRole");
                if (Util.compare2((Comparable)((Integer)level2Map.get("delete")), (Comparable)Integer.valueOf(1)) == 0) continue;
                DefMsgCfService.DefMsgCf level2DefMsgCf = new DefMsgCfService.DefMsgCf();
                level2DefMsgCf.setVer(this.defMsgMappingConfig.getVer());
                level2DefMsgCf.setCode(level2Key);
                level2DefMsgCf.setName(level2Name);
                if (Util.isNotEmpty((CharSequence)level2WebRole)) {
                    level2DefMsgCf.setWebRoleList(Set.of(level2WebRole.split(",")));
                }
                if (Util.isNotEmpty((CharSequence)level2AppRole)) {
                    level2DefMsgCf.setAppRoleList(Set.of(level2AppRole.split(",")));
                }
                level2DefMsgCf.setLocaleMap(this.localeMap(level2Key, level2Name, level2Map));
                level2DefMsgCf.setAppSysNotify(1);
                level2DefMsgCf.setUseJg(1);
                level2DefMsgCf.setUseMail(1);
                level2DefMsgCf.setUseSms(1);
                level2DefMsgCf.setUseWebSocket(1);
                level2DefMsgCf.setPop(1);
                level2DefMsgCf.setFloatWindow(1);
                level2DefMsgCf.setTopWindow(1);
                level2DefMsgCf.setUseQiWei(1);
                level2DefMsgCf.setUseDingDing(1);
                level2DefMsgCf.setUseFeiShu(1);
                level2DefMsgCf.setUseWeiXin(1);
                level2DefMsgCf.setParentCode(level1Key);
                i = this.defMsgMappingConfig.getOrder().indexOf(level2Key);
                if (i == -1) {
                    throw new RuntimeException("message type order is missing???: " + level2Key);
                }
                level2DefMsgCf.setMessageTypeOrderId(i + 1);
                all.add(level2DefMsgCf);
                Map level3 = (Map)level2Map.get("child");
                for (Map.Entry level3Entry : level3.entrySet()) {
                    String level3Key = (String)level3Entry.getKey();
                    Map level3Map = (Map)level3Entry.getValue();
                    String level3Name = (String)level3Map.get("name");
                    String level3AppRole = (String)level3Map.get("appRole");
                    String level3WebRole = (String)level3Map.get("webRole");
                    if (Util.compare2((Comparable)((Integer)level3Map.get("delete")), (Comparable)Integer.valueOf(1)) == 0) continue;
                    DefMsgCfService.DefMsgCf level3DefMsgCf = new DefMsgCfService.DefMsgCf();
                    level3DefMsgCf.setVer(this.defMsgMappingConfig.getVer());
                    level3DefMsgCf.setCode(level3Key);
                    level3DefMsgCf.setName(level3Name);
                    if (Util.isNotEmpty((CharSequence)level3WebRole)) {
                        level3DefMsgCf.setWebRoleList(Set.of(level3WebRole.split(",")));
                    }
                    if (Util.isNotEmpty((CharSequence)level3AppRole)) {
                        level3DefMsgCf.setAppRoleList(Set.of(level3AppRole.split(",")));
                    }
                    level3DefMsgCf.setLocaleMap(this.localeMap(level3Key, level3Name, level3Map));
                    level3DefMsgCf.setParentCode(level2Key);
                    level3DefMsgCf.setAppSysNotify(Optional.ofNullable((Integer)level3Map.get("appSysNotify")).orElse(0));
                    level3DefMsgCf.setUseJg(Optional.ofNullable((Integer)level3Map.get("appSysNotify")).orElse(0));
                    level3DefMsgCf.setUseMail(Optional.ofNullable((Integer)level3Map.get("mail")).orElse(0));
                    level3DefMsgCf.setUseSms(Optional.ofNullable((Integer)level3Map.get("sms")).orElse(0));
                    level3DefMsgCf.setUseWebSocket(Optional.ofNullable((Integer)level3Map.get("wbs")).orElse(0));
                    level3DefMsgCf.setPop(Optional.ofNullable((Integer)level3Map.get("pop")).orElse(0));
                    level3DefMsgCf.setTopWindow(Optional.ofNullable((Integer)level3Map.get("topWindow")).orElse(0));
                    level3DefMsgCf.setFloatWindow(Optional.ofNullable((Integer)level3Map.get("floatWindow")).orElse(0));
                    level3DefMsgCf.setUseQiWei(Optional.ofNullable((Integer)level3Map.get("third")).orElse(0));
                    level3DefMsgCf.setUseDingDing(Optional.ofNullable((Integer)level3Map.get("third")).orElse(0));
                    level3DefMsgCf.setUseFeiShu(Optional.ofNullable((Integer)level3Map.get("third")).orElse(0));
                    level3DefMsgCf.setThird(Optional.ofNullable((Integer)level3Map.get("third")).orElse(0));
                    level3DefMsgCf.setUseWeiXin(1);
                    i = this.defMsgMappingConfig.getOrder().indexOf(level3Key);
                    if (i == -1) {
                        throw new RuntimeException("message type order is missing???: " + level3Key);
                    }
                    level3DefMsgCf.setMessageTypeOrderId(i + 1);
                    all.add(level3DefMsgCf);
                    log.info("load key (" + level3Key + "): " + JSONAccessor.impl().format((Object)level3DefMsgCf));
                }
            }
        }
        if (Util.isNotEmpty(all)) {
            defMsgCfNodeList = Util.constructTree(all, DefMsgCfService.DefMsgCfNode.class);
            for (DefMsgCfService.DefMsgCfNode defMsgCfNode : defMsgCfNodeList) {
                defMsgCfNode.walk(new Consumer<DefMsgCfService.DefMsgCfNode>(this){

                    @Override
                    public void accept(DefMsgCfService.DefMsgCfNode defMsgCfNode) {
                        DefMsgCfService.DefMsgCf defMsgCf = (DefMsgCfService.DefMsgCf)defMsgCfNode.nodeRef();
                        MTC.putIfAbsentAndGet((Comparable)((Object)defMsgCf.getCode()), () -> defMsgCf, Integer.MAX_VALUE, TimeUnit.SECONDS);
                    }
                });
            }
            log.info("load tree view of def msg type");
        }
        for (DefMsgCfService.DefMsgCfNode l1 : defMsgCfNodeList) {
            for (DefMsgCfService.DefMsgCfNode l2 : l1.children()) {
                this.valFromChildren(l2);
            }
            this.valFromChildren(l1);
        }
        final ArrayList<String> msgTypeCodeList = new ArrayList<String>();
        for (DefMsgCfService.DefMsgCfNode defMsgCfNode : this.treeView()) {
            defMsgCfNode.walk(new Consumer<DefMsgCfService.DefMsgCfNode>(){

                @Override
                public void accept(DefMsgCfService.DefMsgCfNode defMsgCfNode) {
                    if (Util.isEmpty((Collection)defMsgCfNode.children())) {
                        msgTypeCodeList.add(((DefMsgCfService.DefMsgCf)defMsgCfNode.nodeRef()).getCode());
                    }
                }
            });
        }
        DefMsgCfServiceImpl.msgTypeCodeList = msgTypeCodeList;
    }

    private void valFromChildren(DefMsgCfService.DefMsgCfNode l2) {
        boolean pop = true;
        boolean appSysNotify = true;
        boolean useJg = true;
        boolean useMail = true;
        boolean useSms = true;
        boolean third = true;
        boolean useQiWei = true;
        boolean useDingDing = true;
        boolean useFeiShu = true;
        for (DefMsgCfService.DefMsgCfNode l3 : l2.children()) {
            pop = pop && ((DefMsgCfService.DefMsgCf)l3.nodeRef()).getPop() == -1;
            appSysNotify = appSysNotify && ((DefMsgCfService.DefMsgCf)l3.nodeRef()).getAppSysNotify() == -1;
            useJg = useJg && ((DefMsgCfService.DefMsgCf)l3.nodeRef()).getUseJg() == -1;
            useMail = useMail && ((DefMsgCfService.DefMsgCf)l3.nodeRef()).getUseMail() == -1;
            useSms = useSms && ((DefMsgCfService.DefMsgCf)l3.nodeRef()).getUseSms() == -1;
            third = third && ((DefMsgCfService.DefMsgCf)l3.nodeRef()).getThird() == -1;
            useQiWei = useQiWei && ((DefMsgCfService.DefMsgCf)l3.nodeRef()).getUseQiWei() == -1;
            useDingDing = useDingDing && ((DefMsgCfService.DefMsgCf)l3.nodeRef()).getUseDingDing() == -1;
            useFeiShu = useFeiShu && ((DefMsgCfService.DefMsgCf)l3.nodeRef()).getUseFeiShu() == -1;
        }
        if (pop) {
            ((DefMsgCfService.DefMsgCf)l2.nodeRef()).setPop(-1);
        }
        if (appSysNotify) {
            ((DefMsgCfService.DefMsgCf)l2.nodeRef()).setAppSysNotify(-1);
        }
        if (useJg) {
            ((DefMsgCfService.DefMsgCf)l2.nodeRef()).setUseJg(-1);
        }
        if (useMail) {
            ((DefMsgCfService.DefMsgCf)l2.nodeRef()).setUseMail(-1);
        }
        if (useSms) {
            ((DefMsgCfService.DefMsgCf)l2.nodeRef()).setUseSms(-1);
        }
        if (third) {
            ((DefMsgCfService.DefMsgCf)l2.nodeRef()).setThird(-1);
        }
        if (useQiWei) {
            ((DefMsgCfService.DefMsgCf)l2.nodeRef()).setUseQiWei(-1);
        }
        if (useDingDing) {
            ((DefMsgCfService.DefMsgCf)l2.nodeRef()).setUseDingDing(-1);
        }
        if (useFeiShu) {
            ((DefMsgCfService.DefMsgCf)l2.nodeRef()).setUseFeiShu(-1);
        }
    }

    private Map<Locale, String> localeMap(String code, String levelName, Map<String, Object> levelMap) {
        HashMap<Locale, String> localeMap = new HashMap<Locale, String>();
        localeMap.put(Locale.CHINA, levelName);
        for (Locale locale : LOCALES) {
            if (locale == Locale.CHINA) continue;
            String message = this.messageSource.getMessage("msg." + code, null, locale);
            localeMap.put(locale, message);
        }
        return localeMap;
    }

    @Override
    public DefMsgCfService.DefMsgCf cfg(String msgTypeCode) {
        return (DefMsgCfService.DefMsgCf)MTC.get((Comparable)((Object)msgTypeCode));
    }

    @Override
    public List<DefMsgCfService.DefMsgCfNode> treeView() {
        return defMsgCfNodeList;
    }

    @Override
    public List<String> allMsgTypeCode() {
        return new ArrayList<String>(msgTypeCodeList);
    }

    @Override
    @Transactional
    public void fsync() {
        String read;
        String file = "message-msg-mapping.yml";
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(file);
        try {
            read = Util.read((Reader)new InputStreamReader(resourceAsStream));
        }
        catch (IOException e) {
            throw Util.convert2RuntimeException((Throwable)e);
        }
        String md5 = Util.md5((String)read);
        log.info(file + " md5: " + md5);
        Cfg cfg = (Cfg)this.cfgMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(Cfg.class).eq(Cfg::getCfgKey, (Object)file)).eq(Cfg::getVer, (Object)this.defMsgMappingConfig.getVer())).eq(Cfg::getDelFlag, (Object)0));
        if (cfg != null) {
            if (!md5.equals(cfg.getCfgMd5())) {
                log.error(file + " , jvm exit,  cfg MD5 conflicts(local:" + md5 + ",db: " + cfg.getCfgMd5() + ")!!!, cfg changes, but do not save to DB???");
                Runtime.getRuntime().exit(-1);
            }
            log.info(" md5 matches: " + md5 + " , latest md5: " + cfg.getCfgMd5());
            return;
        }
        log.info("ready fsync all new config to db, latest ver: " + this.defMsgMappingConfig.getVer());
        Cfg c = new Cfg();
        c.setCfgKey(file);
        c.setCfgText(read);
        c.setCfgMd5(md5);
        c.setVer(this.defMsgMappingConfig.getVer());
        try {
            this.cfgMapper.insert(c);
        }
        catch (Exception e) {
            log.warn(file + " was processed ???");
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        int maxVer = this.messageTypeMapper.maxVer();
        if (this.defMsgMappingConfig.getVer() <= maxVer) {
            throw new RuntimeException("ver conflicts: " + this.defMsgMappingConfig.getVer() + " >? " + maxVer);
        }
        List messageTypeList = this.messageTypeMapper.selectList((Wrapper)new LambdaUpdateWrapper(MessageType.class));
        for (MessageType messageType : messageTypeList) {
            MessageTypeHistory messageTypeHistory = new MessageTypeHistory();
            BeanUtils.copyProperties((Object)messageType, (Object)messageTypeHistory);
            this.messageTypeHistoryMapper.insert(messageTypeHistory);
        }
        this.messageTypeMapper.delete((Wrapper)new LambdaQueryWrapper(MessageType.class));
        this.messagePushTemplateMapper.delete((Wrapper)new LambdaQueryWrapper(MessagePushTemplate.class));
        this.messageTypeVsPushTemplateMapper.delete((Wrapper)new LambdaQueryWrapper(MessageTypeVsPushTemplate.class));
        for (DefMsgCfService.DefMsgCfNode defMsgCfNode : defMsgCfNodeList) {
            defMsgCfNode.walk(new Consumer<DefMsgCfService.DefMsgCfNode>(){

                @Override
                public void accept(DefMsgCfService.DefMsgCfNode defMsgCfNode) {
                    DefMsgCfService.DefMsgCf defMsgCf = (DefMsgCfService.DefMsgCf)defMsgCfNode.nodeRef();
                    if (DefMsgCfServiceImpl.this.getMessageType(defMsgCf.getCode()) != null) {
                        throw new RuntimeException("data conflict:" + defMsgCf.getCode());
                    }
                    if (defMsgCfNode.level() == 0 || defMsgCfNode.level() == 1) {
                        MessageType level1MessageType = new MessageType();
                        level1MessageType.setCode(defMsgCf.getCode());
                        level1MessageType.setName(defMsgCf.getName());
                        level1MessageType.setAppSysNotify(1);
                        level1MessageType.setUseJg(1);
                        level1MessageType.setUseMail(1);
                        level1MessageType.setUseSms(1);
                        level1MessageType.setUseWebSocket(1);
                        level1MessageType.setPop(1);
                        level1MessageType.setFloatWindow(1);
                        level1MessageType.setTopWindow(1);
                        level1MessageType.setUseQiWei(1);
                        level1MessageType.setUseDingDing(1);
                        level1MessageType.setUseFeiShu(1);
                        level1MessageType.setUseWeiXin(1);
                        if (defMsgCfNode.level() != 0) {
                            int messageTypeOrderId = ((DefMsgCfService.DefMsgCf)((DefMsgCfService.DefMsgCfNode)defMsgCfNode.parent()).nodeRef()).getMessageTypeOrderId();
                            level1MessageType.setParentId(messageTypeOrderId);
                        }
                        level1MessageType.setId(defMsgCf.getMessageTypeOrderId());
                        level1MessageType.setCreateAt(LocalDateTime.now());
                        level1MessageType.setCreateBy(-1);
                        level1MessageType.setModifyAt(LocalDateTime.now());
                        level1MessageType.setModifyBy(-1);
                        level1MessageType.setVer(defMsgCf.getVer());
                        DefMsgCfServiceImpl.this.messageTypeMapper.insert(level1MessageType);
                    } else {
                        int messageTypeOrderId = ((DefMsgCfService.DefMsgCf)((DefMsgCfService.DefMsgCfNode)defMsgCfNode.parent()).nodeRef()).getMessageTypeOrderId();
                        DefMsgCfServiceImpl.this.createMsgType(defMsgCf, messageTypeOrderId);
                    }
                }
            });
        }
    }

    private void createMsgType(DefMsgCfService.DefMsgCf defMsgCf, int messageTypeOrderId) {
        String level3Key = defMsgCf.getCode();
        String level3Name = defMsgCf.getName();
        String title = "${_param_content_plain_text_}";
        String content = "${_param_content_plain_text_}";
        String templateEngine = "text";
        MessageType level3MessageType = new MessageType();
        level3MessageType.setCode(level3Key);
        level3MessageType.setName(level3Name);
        level3MessageType.setAppSysNotify(defMsgCf.getAppSysNotify() < 1 ? 0 : 1);
        level3MessageType.setUseJg(defMsgCf.getUseJg() < 1 ? 0 : 1);
        level3MessageType.setUseMail(defMsgCf.getUseMail() < 1 ? 0 : 1);
        level3MessageType.setUseSms(defMsgCf.getUseSms() < 1 ? 0 : 1);
        level3MessageType.setUseWebSocket(1);
        level3MessageType.setPop(defMsgCf.getPop() < 1 ? 0 : 1);
        level3MessageType.setTopWindow(defMsgCf.getTopWindow() < 1 ? 0 : 1);
        level3MessageType.setFloatWindow(defMsgCf.getFloatWindow() < 1 ? 0 : 1);
        level3MessageType.setUseQiWei(defMsgCf.getUseQiWei() < 1 ? 0 : 1);
        level3MessageType.setUseDingDing(defMsgCf.getUseDingDing() < 1 ? 0 : 1);
        level3MessageType.setUseFeiShu(defMsgCf.getUseFeiShu() < 1 ? 0 : 1);
        level3MessageType.setUseWeiXin(defMsgCf.getUseWeiXin() < 1 ? 0 : 1);
        level3MessageType.setParentId(messageTypeOrderId);
        level3MessageType.setId(defMsgCf.getMessageTypeOrderId());
        level3MessageType.setCreateAt(LocalDateTime.now());
        level3MessageType.setCreateBy(-1);
        level3MessageType.setModifyAt(LocalDateTime.now());
        level3MessageType.setModifyBy(-1);
        level3MessageType.setTitleTemplateCn(title);
        level3MessageType.setTitleTemplateTw(title);
        level3MessageType.setTitleTemplateEn(title);
        level3MessageType.setTitleTemplateIndonesia(title);
        level3MessageType.setContentTemplateCn(content);
        level3MessageType.setContentTemplateTw(content);
        level3MessageType.setContentTemplateEn(content);
        level3MessageType.setContentTemplateIndonesia(content);
        level3MessageType.setTemplateEngine("text");
        level3MessageType.setVer(defMsgCf.getVer());
        this.messageTypeMapper.insert(level3MessageType);
        String thirdTemplateCode = level3MessageType.getCode();
        List messagePushTemplateList = this.messagePushTemplateMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(MessagePushTemplate.class).eq(MessagePushTemplate::getThirdTemplateCode, (Object)thirdTemplateCode)).eq(MessagePushTemplate::getDelFlag, (Object)0));
        if (Util.isNotEmpty((Collection)messagePushTemplateList)) {
            this.messageTypeVsPushTemplateMapper.delete((Wrapper)new LambdaQueryWrapper(MessageTypeVsPushTemplate.class).in(MessageTypeVsPushTemplate::getMessagePushTemplateId, (Collection)messagePushTemplateList.stream().map(MessagePushTemplate::getId).collect(Collectors.toList())));
            this.messagePushTemplateMapper.deleteBatchIds(messagePushTemplateList.stream().map(MessagePushTemplate::getId).collect(Collectors.toList()));
        }
        for (Subs s : Subs.values()) {
            if (s == Subs.REUSE) continue;
            int type = s.type();
            MessagePushTemplate messagePushTemplate = new MessagePushTemplate();
            messagePushTemplate.setTitleTemplateCn(title);
            messagePushTemplate.setTitleTemplateTw(title);
            messagePushTemplate.setTitleTemplateEn(title);
            messagePushTemplate.setTitleTemplateIndonesia(title);
            messagePushTemplate.setContentTemplateCn(content);
            messagePushTemplate.setContentTemplateTw(content);
            messagePushTemplate.setContentTemplateEn(content);
            messagePushTemplate.setContentTemplateIndonesia(content);
            messagePushTemplate.setTemplateEngine("text");
            messagePushTemplate.setType(type);
            messagePushTemplate.setThirdTemplateCode(thirdTemplateCode);
            messagePushTemplate.setCreateAt(LocalDateTime.now());
            messagePushTemplate.setCreateBy(-1);
            messagePushTemplate.setModifyAt(LocalDateTime.now());
            messagePushTemplate.setModifyBy(-1);
            this.messagePushTemplateMapper.insert(messagePushTemplate);
            Integer pushTemplateId = messagePushTemplate.getId();
            MessageTypeVsPushTemplate messageTypeVsPushTemplate = new MessageTypeVsPushTemplate();
            messageTypeVsPushTemplate.setMessageTypeId(level3MessageType.getId());
            messageTypeVsPushTemplate.setMessagePushTemplateId(pushTemplateId);
            this.messageTypeVsPushTemplateMapper.insert(messageTypeVsPushTemplate);
        }
    }

    @Override
    @Transactional
    public void compareAndUpdate(final String code) {
        DefMsgCfService.DefMsgCfNode tempDefMsgCfNode;
        DefMsgCfService.DefMsgCf defMsgCf = this.cfg(code);
        if (defMsgCf == null) {
            throw new RuntimeException("data conflict:" + code);
        }
        DefMsgCfService.DefMsgCfNode defMsgCfNode = null;
        Iterator<DefMsgCfService.DefMsgCfNode> iterator = defMsgCfNodeList.iterator();
        while (iterator.hasNext() && (defMsgCfNode = (DefMsgCfService.DefMsgCfNode)(tempDefMsgCfNode = iterator.next()).get(new Predicate<DefMsgCfService.DefMsgCfNode>(){

            @Override
            public boolean test(DefMsgCfService.DefMsgCfNode defMsgCfNode) {
                return Util.compare2((Comparable)((Object)((DefMsgCfService.DefMsgCf)defMsgCfNode.nodeRef()).getCode()), (Comparable)((Object)code)) == 0;
            }
        })) == null) {
        }
        if (defMsgCfNode == null) {
            throw new RuntimeException("data conflict, node is missing???:" + code);
        }
        int level = defMsgCfNode.level();
        MessageType messageType = this.getMessageType(code);
        if (messageType != null) {
            if (level == 0 || level == 1) {
                return;
            }
            messageType.setAppSysNotify(defMsgCf.getAppSysNotify() < 1 ? 0 : 1);
            messageType.setUseJg(defMsgCf.getUseJg() < 1 ? 0 : 1);
            messageType.setUseMail(defMsgCf.getUseMail() < 1 ? 0 : 1);
            messageType.setUseSms(defMsgCf.getUseSms() < 1 ? 0 : 1);
            messageType.setUseWebSocket(defMsgCf.getUseWebSocket() < 1 ? 0 : 1);
            messageType.setPop(defMsgCf.getPop() < 1 ? 0 : 1);
            messageType.setTopWindow(defMsgCf.getTopWindow() < 1 ? 0 : 1);
            messageType.setFloatWindow(defMsgCf.getFloatWindow() < 1 ? 0 : 1);
            messageType.setUseQiWei(defMsgCf.getUseQiWei() < 1 ? 0 : 1);
            messageType.setUseDingDing(defMsgCf.getUseDingDing() < 1 ? 0 : 1);
            messageType.setUseFeiShu(defMsgCf.getUseFeiShu() < 1 ? 0 : 1);
            messageType.setUseWeiXin(defMsgCf.getUseWeiXin() < 1 ? 0 : 1);
            messageType.setModifyAt(LocalDateTime.now());
            this.messageTypeMapper.updateById(messageType);
        } else {
            if (level == 0 || level == 1) {
                MessageType level1MessageType = new MessageType();
                level1MessageType.setCode(defMsgCf.getCode());
                level1MessageType.setName(defMsgCf.getName());
                level1MessageType.setAppSysNotify(1);
                level1MessageType.setUseJg(1);
                level1MessageType.setUseMail(1);
                level1MessageType.setUseSms(1);
                level1MessageType.setUseWebSocket(1);
                level1MessageType.setPop(1);
                level1MessageType.setFloatWindow(1);
                level1MessageType.setTopWindow(1);
                level1MessageType.setUseQiWei(1);
                level1MessageType.setUseDingDing(1);
                level1MessageType.setUseFeiShu(1);
                level1MessageType.setUseWeiXin(1);
                if (level != 0) {
                    int messageTypeOrderId = ((DefMsgCfService.DefMsgCf)((DefMsgCfService.DefMsgCfNode)defMsgCfNode.parent()).nodeRef()).getMessageTypeOrderId();
                    level1MessageType.setParentId(messageTypeOrderId);
                }
                level1MessageType.setId(defMsgCf.getMessageTypeOrderId());
                level1MessageType.setCreateAt(LocalDateTime.now());
                level1MessageType.setCreateBy(-1);
                level1MessageType.setModifyAt(LocalDateTime.now());
                level1MessageType.setModifyBy(-1);
                this.messageTypeMapper.insert(level1MessageType);
                return;
            }
            MessageType parent = this.getMessageType(defMsgCf.getParentCode());
            if (parent == null) {
                throw new RuntimeException("data conflict:" + defMsgCf.getCode());
            }
            this.createMsgType(defMsgCf, parent.getId());
        }
    }

    private MessageType getMessageType(String code) {
        MessageType messageType = (MessageType)this.messageTypeMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(MessageType.class).eq(MessageType::getCode, (Object)code)).eq(MessageType::getDelFlag, (Object)0));
        return messageType;
    }
}

