/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.config;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.time.StopWatch;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
@Order(value=0)
public class ControllerAspect {
    private static final Logger log = LoggerFactory.getLogger(ControllerAspect.class);

    @Pointcut(value="execution(* com.ovopark.messagehub.kernel.controller.*.*(..))  || execution(* com.ovopark.messagehub.control.feign.*.*(..))  || execution(* com.ovopark.messagehub.manage.server.controller.*.*(..)) ")
    public void requestCut() {
    }

    @Around(value="requestCut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            String requestURI = request.getRequestURI();
            Signature signature = pjp.getSignature();
            String signatureName = signature.getName();
            StopWatch stopWatch = StopWatch.createStarted();
            Object object = pjp.proceed();
            log.info(requestURI + " > exec method: " + signatureName + " , cost: " + stopWatch.formatTime());
            return object;
        }
        return pjp.proceed();
    }
}

