/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.kernel.MsgHubSharedConfig;
import com.ovopark.messagehub.kernel.model.es.UserMessage;
import com.ovopark.module.shared.es7x.ElasticsearchManager;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserMessageAliasIndexRefreshListener
implements ElasticsearchManager.AliasIndexRefreshListener {
    private static final Logger log = LoggerFactory.getLogger(UserMessageAliasIndexRefreshListener.class);
    @Autowired
    private MsgHubSharedConfig msgHubSharedConfig;

    public ElasticsearchManager.Entry on(String alias, List<ElasticsearchOperations.AliasIndex> aliasIndexList) {
        if (!UserMessage.INDEX_WRITE.equals(alias)) {
            return null;
        }
        ElasticsearchManager.Entry entry = new ElasticsearchManager.Entry();
        int searchableDays = this.msgHubSharedConfig.getSearchableDays();
        LocalDateTime day = LocalDateTime.now().minusDays(searchableDays);
        String prefix = UserMessage.PREFIX + Util.formatTime((LocalDateTime)day, (String[])new String[]{"yyyy.MM.dd"});
        List<String> list = aliasIndexList.stream().map(ElasticsearchOperations.AliasIndex::getIndex).filter(i -> i.startsWith(UserMessage.PREFIX) && i.compareTo(prefix) > 0).sorted(Comparator.naturalOrder().reversed()).limit(Math.max(this.msgHubSharedConfig.getMaxSearchableIndexCount(), 1)).toList();
        log.info("searchableIndex: " + JSONAccessor.impl().format(list) + ", prefix: " + prefix);
        entry.setKey("searchableIndex:" + alias);
        entry.setObject(list);
        return entry;
    }
}

