/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheServiceV2;
import com.ovopark.messagehub.kernel.DefTodoMsgCfService;
import com.ovopark.messagehub.kernel.DefTodoMsgMappingConfig;
import com.ovopark.messagehub.kernel.MsgHubSharedConfig;
import com.ovopark.messagehub.kernel.TodoMsgCategoryCount;
import com.ovopark.messagehub.kernel.mapper.TodoMessageMapper;
import com.ovopark.module.shared.SharedLocale;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.stereotype.Component;

@Component
public class DefTodoMsgCfServiceImpl
implements DefTodoMsgCfService {
    private static final Logger log = LoggerFactory.getLogger(DefTodoMsgCfServiceImpl.class);
    private static final Locale[] LOCALES = new Locale[]{Locale.CHINA, Locale.US, Locale.TAIWAN, SharedLocale.IN_ID, Locale.JAPAN, Locale.ITALY};
    @Autowired
    private DefTodoMsgMappingConfig defTodoMsgMappingConfig;
    static final CacheServiceV2<String> MTC = CacheServiceV2.impl();
    static volatile List<DefTodoMsgCfService.DefTodoMsgCfNode> defTodoMsgCfNodeList;
    static volatile List<DefTodoMsgCfService.DefTodoMsgCfNodeView> defTodoMsgCfNodeViewList;
    static volatile String JSON_STR;
    @Autowired
    private TodoMessageMapper todoMessageMapper;
    @Resource(name="messageMainRedis")
    private RedisOperations redisOperations;
    @Autowired
    private MsgHubSharedConfig msgHubSharedConfig;
    @Autowired
    private MessageSource messageSource;

    @PostConstruct
    private void post() {
        try {
            this.post0();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            log.error("we need exit JVM: cannot load todo message type tree");
            Runtime.getRuntime().exit(-1);
        }
    }

    private void post0() {
        ArrayList<DefTodoMsgCfService.DefTodoMsgCf> all = new ArrayList<DefTodoMsgCfService.DefTodoMsgCf>();
        for (Map.Entry<String, Map<String, Object>> entry : this.defTodoMsgMappingConfig.getMsgTree().entrySet()) {
            String level1Key = entry.getKey();
            Map<String, Object> level1Map = entry.getValue();
            String level1Name = (String)level1Map.get("name");
            Map level2 = (Map)level1Map.get("child");
            DefTodoMsgCfService.DefTodoMsgCf level1DefTodoMsgCf = new DefTodoMsgCfService.DefTodoMsgCf();
            level1DefTodoMsgCf.setVer(this.defTodoMsgMappingConfig.getVer());
            level1DefTodoMsgCf.setName(level1Name);
            level1DefTodoMsgCf.setCode(level1Key);
            level1DefTodoMsgCf.setLocaleMap(this.localeMap(level1Key, level1Name, null));
            all.add(level1DefTodoMsgCf);
            log.info("load key (" + level1Key + "): " + JSONAccessor.impl().format((Object)level1DefTodoMsgCf));
            for (Map.Entry mapEntry : level2.entrySet()) {
                String level2Key = (String)mapEntry.getKey();
                Map level2Map = (Map)mapEntry.getValue();
                String level2Name = (String)level2Map.get("name");
                DefTodoMsgCfService.DefTodoMsgCf level2DefTodoMsgCf = new DefTodoMsgCfService.DefTodoMsgCf();
                level2DefTodoMsgCf.setVer(this.defTodoMsgMappingConfig.getVer());
                level2DefTodoMsgCf.setName(level2Name);
                level2DefTodoMsgCf.setCode(level2Key);
                level2DefTodoMsgCf.setParentCode(level1Key);
                level2DefTodoMsgCf.setLocaleMap(this.localeMap(level2Key, level2Name, null));
                all.add(level2DefTodoMsgCf);
                log.info("load key (" + level2Key + "): " + JSONAccessor.impl().format((Object)level2DefTodoMsgCf));
            }
        }
        if (Util.isNotEmpty(all)) {
            defTodoMsgCfNodeList = Util.constructTree(all, DefTodoMsgCfService.DefTodoMsgCfNode.class);
            for (DefTodoMsgCfService.DefTodoMsgCfNode defTodoMsgCfNode : defTodoMsgCfNodeList) {
                defTodoMsgCfNode.walk(new Consumer<DefTodoMsgCfService.DefTodoMsgCfNode>(this){

                    @Override
                    public void accept(DefTodoMsgCfService.DefTodoMsgCfNode todoMsgCfNode) {
                        DefTodoMsgCfService.DefTodoMsgCf defMsgCf = (DefTodoMsgCfService.DefTodoMsgCf)todoMsgCfNode.nodeRef();
                        MTC.putIfAbsentAndGet((Comparable)((Object)defMsgCf.getCode()), () -> defMsgCf);
                    }
                });
            }
            log.info("load tree view of def todo msg type");
        }
        ArrayList<DefTodoMsgCfService.DefTodoMsgCfNodeView> todoMsgCfNodeViewList = new ArrayList<DefTodoMsgCfService.DefTodoMsgCfNodeView>();
        HashSet<String> assignedCategories = new HashSet<String>();
        Map<String, Map<String, Object>> group = this.defTodoMsgMappingConfig.getGroup();
        for (Map.Entry<String, Map<String, Object>> mapEntry : group.entrySet()) {
            String key = mapEntry.getKey();
            Map<String, Object> value = mapEntry.getValue();
            String name = (String)value.get("name");
            Integer order = (Integer)value.get("order");
            ArrayList list = new ArrayList(((Map)value.get("child")).values());
            DefTodoMsgCfService.DefTodoMsgCfNodeView p = new DefTodoMsgCfService.DefTodoMsgCfNodeView();
            p.setCode(key);
            p.setName(name);
            p.setLocaleMap(this.localeMap(key, name, null));
            p.setOrder(order == null ? 0 : order);
            todoMsgCfNodeViewList.add(p);
            for (String c : list) {
                DefTodoMsgCfService.DefTodoMsgCfNodeView defTodoMsgCfNodeView = new DefTodoMsgCfService.DefTodoMsgCfNodeView();
                defTodoMsgCfNodeView.setParentCode(key);
                defTodoMsgCfNodeView.setCode(c);
                for (DefTodoMsgCfService.DefTodoMsgCfNode defTodoMsgCfNode : defTodoMsgCfNodeList) {
                    DefTodoMsgCfService.DefTodoMsgCfNode cfNode = (DefTodoMsgCfService.DefTodoMsgCfNode)defTodoMsgCfNode.get(todoMsgCfNode -> ((DefTodoMsgCfService.DefTodoMsgCf)todoMsgCfNode.nodeRef()).getCode().equals(c));
                    if (cfNode == null) continue;
                    String n = ((DefTodoMsgCfService.DefTodoMsgCf)cfNode.nodeRef()).getName();
                    defTodoMsgCfNodeView.setName(n);
                    break;
                }
                defTodoMsgCfNodeView.setLocaleMap(this.localeMap(c, defTodoMsgCfNodeView.getName(), null));
                p.getChildren().add(defTodoMsgCfNodeView);
                assignedCategories.add(c);
            }
        }
        todoMsgCfNodeViewList.sort(Comparator.comparing(DefTodoMsgCfService.DefTodoMsgCfNodeView::getOrder));
        defTodoMsgCfNodeViewList = todoMsgCfNodeViewList;
        JSON_STR = JSONAccessor.impl().format(defTodoMsgCfNodeViewList);
    }

    private Map<Locale, String> localeMap(String code, String levelName, Map<String, Object> levelMap) {
        HashMap<Locale, String> localeMap = new HashMap<Locale, String>();
        localeMap.put(Locale.CHINA, levelName);
        for (Locale locale : LOCALES) {
            if (locale == Locale.CHINA) continue;
            String message = this.messageSource.getMessage("todoMsg." + code, null, locale);
            localeMap.put(locale, message);
        }
        return localeMap;
    }

    @Override
    public DefTodoMsgCfService.DefTodoMsgCf cfg(String category, String objectType) {
        if (Util.isEmpty((CharSequence)objectType)) {
            return (DefTodoMsgCfService.DefTodoMsgCf)MTC.get((Comparable)((Object)category));
        }
        return (DefTodoMsgCfService.DefTodoMsgCf)MTC.get((Comparable)((Object)objectType));
    }

    @Override
    public List<DefTodoMsgCfService.DefTodoMsgCfNode> treeView() {
        return defTodoMsgCfNodeList;
    }

    @Override
    public List<DefTodoMsgCfService.DefTodoMsgCfNodeView> groupView(final int userId, final int type, final boolean refresh) {
        final String key = type == 1 ? "messagehub:todoMsg:categoryCount:to:" + userId : "messagehub:todoMsg:categoryCount:cc:" + userId;
        List todoMsgCategoryCountList = null;
        Object object = refresh ? null : this.redisOperations.opsForValue().get((Object)key);
        todoMsgCategoryCountList = object == null || Util.isEmpty((CharSequence)String.valueOf(object)) ? (List)Util.lock((Comparable)((Object)key), (Callable)new Callable<List<TodoMsgCategoryCount>>(){

            @Override
            public List<TodoMsgCategoryCount> call() throws Exception {
                List<TodoMsgCategoryCount> list;
                Object tmp;
                Object object = tmp = refresh ? null : DefTodoMsgCfServiceImpl.this.redisOperations.opsForValue().get((Object)key);
                if (tmp == null || Util.isEmpty((CharSequence)String.valueOf(tmp))) {
                    list = DefTodoMsgCfServiceImpl.this.todoMessageMapper.categoryDiffCount(userId, type, Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]));
                    DefTodoMsgCfServiceImpl.this.redisOperations.opsForValue().set((Object)key, (Object)JSONAccessor.impl().format(list), (long)DefTodoMsgCfServiceImpl.this.msgHubSharedConfig.getTodoMsgGroupViewExpiredSec(), TimeUnit.SECONDS);
                } else {
                    list = (List<TodoMsgCategoryCount>)JSONAccessor.impl().read(String.valueOf(tmp), (JSONAccessor.TypeReference)new JSONAccessor.TypeReference<List<TodoMsgCategoryCount>>(this){});
                }
                return list;
            }
        }, (long)15L, (TimeUnit)TimeUnit.SECONDS) : (List)JSONAccessor.impl().read(String.valueOf(object), (JSONAccessor.TypeReference)new JSONAccessor.TypeReference<List<TodoMsgCategoryCount>>(this){});
        List defTodoMsgCfNodeViewList = (List)JSONAccessor.impl().read(JSON_STR, (JSONAccessor.TypeReference)new JSONAccessor.TypeReference<List<DefTodoMsgCfService.DefTodoMsgCfNodeView>>(this){});
        Map<String, TodoMsgCategoryCount> map = todoMsgCategoryCountList.stream().collect(Collectors.toMap(k -> k.getCategory() + ":" + k.getSubGroup(), v -> v));
        for (DefTodoMsgCfService.DefTodoMsgCfNodeView defTodoMsgCfNodeView : defTodoMsgCfNodeViewList) {
            for (DefTodoMsgCfService.DefTodoMsgCfNodeView child : defTodoMsgCfNodeView.getChildren()) {
                TodoMsgCategoryCount overdueCount;
                String code = child.getCode();
                TodoMsgCategoryCount inProgressCount = map.get(code + ":0");
                if (inProgressCount != null) {
                    child.setInProgressCount(inProgressCount.getCount());
                }
                if ((overdueCount = map.get(code + ":1")) != null) {
                    child.setOverdueCount(overdueCount.getCount());
                }
                child.setCount(child.getInProgressCount() + child.getOverdueCount());
            }
            defTodoMsgCfNodeView.getChildren().sort(Comparator.comparing(DefTodoMsgCfService.DefTodoMsgCfNodeView::getCount).reversed());
        }
        return defTodoMsgCfNodeViewList;
    }

    @Override
    public List<String> group(String group) {
        ArrayList<String> list = new ArrayList<String>();
        for (DefTodoMsgCfService.DefTodoMsgCfNodeView defTodoMsgCfNodeView : defTodoMsgCfNodeViewList) {
            if (!defTodoMsgCfNodeView.getCode().equals(group)) continue;
            for (DefTodoMsgCfService.DefTodoMsgCfNodeView child : defTodoMsgCfNodeView.getChildren()) {
                list.add(child.getCode());
            }
        }
        return list;
    }
}

