/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.messagehub.kernel.Keys;
import com.ovopark.messagehub.kernel.MsgCfService;
import com.ovopark.messagehub.kernel.MsgHubSharedConfig;
import com.ovopark.messagehub.kernel.MsgTypeConfigNode;
import com.ovopark.messagehub.kernel.UserMsgTypeConfig;
import com.ovopark.messagehub.kernel.UserMsgTypeConfigImpl;
import com.ovopark.messagehub.kernel.service.impl.MsgConfigSharedServiceImpl;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.stereotype.Component;

@Component
public class SimpleMsgCfService
implements MsgCfService {
    private static final Logger log = LoggerFactory.getLogger(SimpleMsgCfService.class);
    @Resource(name="messageMainRedis")
    private RedisOperations redisOperations;
    private static final CacheService<String, UserMsgTypeConfigImpl> cacheService = CacheService.map();
    private static final ExecutorService B = new ThreadPoolExecutor(0, 4, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2000), Util.newThreadFactory((String)"user-cfg-push-redis"), new ThreadPoolExecutor.DiscardPolicy());
    @Autowired
    private MsgConfigSharedServiceImpl msgConfigSharedService;
    @Autowired
    private MsgHubSharedConfig msgHubConfig;

    private String key(Integer groupId, Integer userId, String code) {
        return Keys.userCfOnMsgTypeKey(userId, code);
    }

    @Override
    public UserMsgTypeConfig cfOnSelf(Integer groupId, Integer userId, String code) {
        String key = this.key(groupId, userId, code);
        UserMsgTypeConfigImpl userMsgTypeConfigImpl = (UserMsgTypeConfigImpl)cacheService.get((Comparable)((Object)key));
        if (userMsgTypeConfigImpl == null) {
            StopWatch tmp = null;
            if (this.msgHubConfig.isVerbose()) {
                tmp = StopWatch.createStarted();
                log.info("to get cfg from redis: " + key);
            }
            Object object = this.redisOperations.opsForValue().get((Object)key);
            if (this.msgHubConfig.isVerbose()) {
                log.info("get result from redis: " + key + ", cost: " + (tmp == null ? "" : tmp.formatTime()));
            }
            userMsgTypeConfigImpl = object == null ? (UserMsgTypeConfigImpl)Util.lock((Comparable)((Object)("messagehub:userCf:" + userId)), () -> {
                UserMsgTypeConfigImpl umtc = null;
                Object object1 = this.redisOperations.opsForValue().get((Object)key);
                if (object1 == null) {
                    log.info("redis miss, we get cfg from db: " + key);
                    StopWatch stopWatch = StopWatch.createStarted();
                    List<MsgTypeConfigNode> userConfigList = this.msgConfigSharedService.userConfig(groupId, userId);
                    log.info("redis miss, get cfg from db: " + key + ", cost time: " + stopWatch.formatTime());
                    AtomicReference find = new AtomicReference();
                    for (MsgTypeConfigNode node : userConfigList) {
                        node.walk(msgTypeConfigNode -> {
                            UserMsgTypeConfigImpl config = (UserMsgTypeConfigImpl)msgTypeConfigNode.nodeRef();
                            String k = this.key(groupId, userId, config.getCode());
                            if (config.getCode().equals(code)) {
                                find.set(config);
                                this.redisOperations.opsForValue().set((Object)k, (Object)JSONAccessor.impl().format((Object)config), (long)this.msgHubConfig.getMsgCfgExpiredSec(), TimeUnit.SECONDS);
                            } else {
                                B.execute(Util.catchRunnable(() -> this.redisOperations.opsForValue().set((Object)k, (Object)JSONAccessor.impl().format((Object)config), (long)this.msgHubConfig.getMsgCfgExpiredSec(), TimeUnit.SECONDS)));
                            }
                        });
                    }
                    if (find.get() == null) {
                        umtc = UserMsgTypeConfigImpl.NO_CONTROL;
                        this.redisOperations.opsForValue().set((Object)key, (Object)JSONAccessor.impl().format((Object)UserMsgTypeConfigImpl.NO_CONTROL), (long)this.msgHubConfig.getMsgCfgExpiredSec(), TimeUnit.SECONDS);
                    } else {
                        umtc = (UserMsgTypeConfigImpl)find.get();
                    }
                    log.info("get data and push redis ,cost " + stopWatch.formatTime());
                } else {
                    umtc = (UserMsgTypeConfigImpl)JSONAccessor.impl().read(String.valueOf(object1), UserMsgTypeConfigImpl.class);
                }
                return umtc;
            }, (long)15L, (TimeUnit)TimeUnit.SECONDS) : (UserMsgTypeConfigImpl)JSONAccessor.impl().read(String.valueOf(object), UserMsgTypeConfigImpl.class);
            UserMsgTypeConfigImpl c = userMsgTypeConfigImpl;
            cacheService.putIfAbsentAndGet((Comparable)((Object)key), () -> c, (long)this.msgHubConfig.getMsgCfgLocalExpiredSec(), TimeUnit.SECONDS);
        }
        if (userMsgTypeConfigImpl.isMissMark()) {
            throw new IllegalArgumentException("code is not supported: " + key);
        }
        return userMsgTypeConfigImpl;
    }

    @Override
    public UserMsgTypeConfig cfOnLink(Integer groupId, Integer userId, String code) {
        return null;
    }
}

