/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.messagehub.kernel.DefMsgCfService;
import com.ovopark.messagehub.kernel.model.es.UserMsgPosition;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface UserMsgPositionService {
    public List<UserMsgPosition.Position> position(int var1, List<String> var2);

    public void upsertDeletePosition(int var1, long var2, List<String> var4);

    public void upsertReadPosition(int var1, long var2, List<String> var4);

    public static class UserMsgPositionReadService {
        private final ElasticsearchOperations elasticsearchOperations;
        private final DefMsgCfService defMsgCfService;
        private final CacheService<String, UserMsgConf> C = new CacheService.MapCacheService(true);

        public UserMsgPositionReadService(ElasticsearchOperations elasticsearchOperations, DefMsgCfService defMsgCfService) {
            this.elasticsearchOperations = elasticsearchOperations;
            this.defMsgCfService = defMsgCfService;
        }

        public int cacheSize() {
            return this.C.size();
        }

        public void foreach(Consumer<Integer> consumer) {
            this.C.forEach((s, userMsgConf) -> consumer.accept(userMsgConf.userId));
        }

        public void cache(int userId, List<String> codeList, int expiredTimeSec, Supplier<UserMsgPosition> supplier) {
            this.cache0(userId, codeList, expiredTimeSec, supplier);
        }

        private UserMsgConf cache0(final int userId, List<String> codeList, int expiredTimeSec, final Supplier<UserMsgPosition> supplier) {
            return (UserMsgConf)this.C.updateAndGet((Comparable)((Object)(UserMsgConf.class.getName() + ":" + userId)), (Function)new Function<UserMsgConf, UserMsgConf>(){

                @Override
                public UserMsgConf apply(UserMsgConf userMsgConf) {
                    if (userMsgConf == null) {
                        userMsgConf = new UserMsgConf();
                        userMsgConf.setUserId(userId);
                        UserMsgPosition userMsgPosition = (UserMsgPosition)supplier.get();
                        userMsgConf.setUserMsgPosition(userMsgPosition);
                    }
                    return userMsgConf;
                }
            }, (long)expiredTimeSec, TimeUnit.SECONDS);
        }

        public List<UserMsgPosition.Position> get(int userId, List<String> codeList) {
            if (Util.isEmpty(codeList)) {
                return List.of();
            }
            UserMsgConf userMsgConf = (UserMsgConf)this.C.get((Comparable)((Object)(UserMsgConf.class.getName() + ":" + userId)));
            if (userMsgConf == null) {
                return List.of();
            }
            return UserMsgPositionReadService.get0(codeList, userMsgConf);
        }

        public List<UserMsgPosition.Position> position(int userId, List<String> codeList) {
            return this.position(userId, codeList, 1);
        }

        public List<UserMsgPosition.Position> position(final int userId, List<String> codeList, int expiredTimeSec) {
            return this.position(userId, codeList, expiredTimeSec, new Supplier<UserMsgPosition>(){

                @Override
                public UserMsgPosition get() {
                    return (UserMsgPosition)elasticsearchOperations.get(UserMsgPosition.INDEX, String.valueOf(userId), UserMsgPosition.class);
                }
            });
        }

        public List<UserMsgPosition.Position> position(int userId, List<String> codeList, int expiredTimeSec, Supplier<UserMsgPosition> supplier) {
            if (Util.isEmpty(codeList)) {
                return List.of();
            }
            UserMsgConf userMsgConf = this.cache0(userId, codeList, expiredTimeSec, supplier);
            return UserMsgPositionReadService.get0(codeList, userMsgConf);
        }

        private static List<UserMsgPosition.Position> get0(List<String> codeList, UserMsgConf userMsgConf) {
            if (userMsgConf.getUserMsgPosition() == null) {
                return List.of();
            }
            ArrayList<UserMsgPosition.Position> positionList = new ArrayList<UserMsgPosition.Position>(codeList.size());
            for (String c : codeList) {
                UserMsgPosition.Position position = userMsgConf.getUserMsgPosition().getMsgTypePosition().get(c);
                if (position == null) {
                    position = new UserMsgPosition.Position();
                    position.setCode(c);
                    position.setReadPositionMs(0L);
                    position.setDeletePositionMs(0L);
                }
                positionList.add(position);
            }
            return positionList;
        }

        public void shutdown() {
            try {
                this.C.shutdown();
            }
            catch (Exception e) {
                throw Util.convert2RuntimeException((Throwable)e);
            }
        }
    }

    public static class UserMsgConf {
        private int userId;
        private UserMsgPosition userMsgPosition;

        public int getUserId() {
            return this.userId;
        }

        public UserMsgPosition getUserMsgPosition() {
            return this.userMsgPosition;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public void setUserMsgPosition(UserMsgPosition userMsgPosition) {
            this.userMsgPosition = userMsgPosition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserMsgConf)) {
                return false;
            }
            UserMsgConf other = (UserMsgConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUserId() != other.getUserId()) {
                return false;
            }
            UserMsgPosition this$userMsgPosition = this.getUserMsgPosition();
            UserMsgPosition other$userMsgPosition = other.getUserMsgPosition();
            return !(this$userMsgPosition == null ? other$userMsgPosition != null : !((Object)this$userMsgPosition).equals(other$userMsgPosition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserMsgConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getUserId();
            UserMsgPosition $userMsgPosition = this.getUserMsgPosition();
            result = result * 59 + ($userMsgPosition == null ? 43 : ((Object)$userMsgPosition).hashCode());
            return result;
        }

        public String toString() {
            return "UserMsgPositionService.UserMsgConf(userId=" + this.getUserId() + ", userMsgPosition=" + String.valueOf(this.getUserMsgPosition()) + ")";
        }
    }
}

