/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.messagehub.kernel.mapper.TodoMsgTagIdMapper;
import com.ovopark.messagehub.kernel.mapper.TodoMsgTagMapper;
import com.ovopark.messagehub.kernel.model.entity.TodoMsgTag;
import com.ovopark.messagehub.kernel.model.entity.TodoMsgTagId;
import com.ovopark.messagehub.kernel.service.TodoMsgTagService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TodoMsgTagServiceImpl
implements TodoMsgTagService {
    private static final int MAX_VALUE = 300000000;
    @Autowired
    private TodoMsgTagMapper todoMsgTagMapper;
    @Autowired
    private TodoMsgTagIdMapper todoMsgTagIdMapper;

    @Override
    public Long getTag(String md5) {
        TodoMsgTag todoMsgTag = (TodoMsgTag)this.todoMsgTagMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TodoMsgTag.class).eq(TodoMsgTag::getMd5, (Object)md5)).select(new SFunction[]{TodoMsgTag::getId}));
        if (todoMsgTag != null && todoMsgTag.getId() < 300000000L) {
            throw new IllegalStateException("invalid tag value, must larger than 300000000");
        }
        return todoMsgTag == null ? null : todoMsgTag.getId();
    }

    @Override
    public long saveTag(String md5, String content) {
        TodoMsgTag todoMsgTag = (TodoMsgTag)this.todoMsgTagMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TodoMsgTag.class).eq(TodoMsgTag::getMd5, (Object)md5)).select(new SFunction[]{TodoMsgTag::getId}));
        if (todoMsgTag != null) {
            return todoMsgTag.getId();
        }
        long l = this.nextTag();
        todoMsgTag = new TodoMsgTag();
        todoMsgTag.setId(l);
        todoMsgTag.setMd5(md5);
        todoMsgTag.setContent(content);
        this.todoMsgTagMapper.insert(todoMsgTag);
        return l;
    }

    @Override
    public long nextTag() {
        TodoMsgTagId todoMsgTagId = new TodoMsgTagId();
        this.todoMsgTagIdMapper.insert(todoMsgTagId);
        Long l = todoMsgTagId.getId();
        if (l < 300000000L) {
            throw new IllegalStateException("invalid tag value, must larger than 300000000");
        }
        return l;
    }
}

