/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.messagehub.kernel.rpc.RPCService;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.jdk21.JakartaServletRequest;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.rbac.SessionClient;
import com.ovopark.sso.api.TokenApi;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthenticationInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    @Autowired
    @Lazy
    private RPCService rpcService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    @Lazy
    private TokenApi tokenApi;
    @Autowired
    private SessionClient sessionClient;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        if (request.getRequestURL().toString().contains("/feign/log") || request.getRequestURL().toString().contains("/feign/device-log/") || request.getRequestURL().toString().contains("/error") || request.getRequestURL().toString().contains("/k8s/health") || request.getRequestURL().toString().contains("/k8s/shutdown") || request.getRequestURL().toString().contains("/test/messageType/import") || request.getRequestURL().toString().contains("/feign/messagehub-job/processing/submit")) {
            return true;
        }
        try {
            Session session = this.sessionClient.session((SharedRequest)new JakartaServletRequest(request));
            if (session != null) {
                Session.getOrCreate().set(session);
                return true;
            }
            response.setContentType("application/json;charset=utf-8");
            response.getWriter().append(JSONAccessor.impl().format((Object)BaseResult.invalidToken()));
            return false;
        }
        catch (Exception e) {
            log.error("AuthenticationInterceptor error:", (Throwable)e);
            response.setContentType("application/json;charset=utf-8");
            response.getWriter().append(JSONAccessor.impl().format((Object)BaseResult.invalidToken()));
            return false;
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Session.getOrCreate().remove();
    }
}

