/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    public static final String LINK_DISPLAY_DATE_DOT = "yyyy.MM.dd";
    public static final String LINK_DISPLAY_DATE = "yyyy-MM-dd";
    public static final String LINK_DISPLAY_DATE_SLASH = "yyyy/MM/dd";
    public static final String LINK_DISPLAY_DATE_FULL = "yyyy-MM-dd HH:mm:ss";
    public static final String LINK_DISPLAY_DATE_MONTH = "yyyy-MM";
    public static final String LINK_DISPLAY_DATE_MONTH_SHORT = "yy-MM";
    public static final String LINK_DISPLAY_DATE_HOURS = "yyyy-MM-dd HH";
    public static final String LINK_DISPLAY_DATE_MINUTE = "yyyy-MM-dd HH:mm";
    public static final String LINK_DISPLAY_DATE_HMS = "HH:mm:ss";
    public static final String LINK_DISPLAY_TIME_HM = "HH:mm";
    public static final String LINK_DATABASE_DATE_FUll = "yyyyMMddHHmmss";
    public static final String LINK_DATABASE_DATE_MSEL = "yyyyMMddHHmmssSSS";
    public static final int TIME_MINUTE = 0;
    public static final int TIME_HOUR = 1;
    public static final int TIME_DAY = 2;
    public static final int TIME_WEEK = 3;
    public static final int TIME_MONTH = 4;
    public static final int TIME_QUARTER = 5;
    public static final int TIME_YEAR = 6;
    public static final int WEEK_DAY = 7;
    public static final int TIME_WEEK_FIRST_DAY = 8;
    public static final int TIME_DAY_FULL = 9;
    public static final int TIME_DATE = 10;
    public static final int TIME_MONTH_FULL = 11;
    public static final int TIME_QUARTER_FULL = 12;
    public static final int TIME_YEAR_FULL = 13;

    public static long getTimeDifBetweenTwoDate(Date stratDate, Date endDate) {
        long stratDateTime = stratDate.getTime();
        long endDateTime = endDate.getTime();
        return stratDateTime - endDateTime;
    }

    public static int getCurrentTimeFlag(int timeType) {
        int output = 0;
        Calendar cal = Calendar.getInstance();
        switch (timeType) {
            case 6: {
                output = cal.get(1);
                break;
            }
            case 4: {
                output = cal.get(2) + 1;
                break;
            }
            case 2: {
                output = cal.get(5);
                break;
            }
            case 1: {
                output = cal.get(11);
            }
        }
        return output;
    }

    public static String getDateStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(LINK_DISPLAY_DATE_FULL);
        return format.format(date);
    }

    public static String getDateStr(Date date, String formatStr) {
        SimpleDateFormat fomate = new SimpleDateFormat(formatStr);
        return fomate.format(date);
    }

    public static Date getDateStart(Date date) {
        String dateStartStr = DateUtils.getDateStr(date, LINK_DISPLAY_DATE) + " 00:00:00";
        return DateUtils.StringToDate(dateStartStr, LINK_DISPLAY_DATE_FULL);
    }

    public static Date getDateEnd(Date date) {
        String dateEndStr = DateUtils.getDateStr(date, LINK_DISPLAY_DATE) + " 23:59:59";
        return DateUtils.StringToDate(dateEndStr, LINK_DISPLAY_DATE_FULL);
    }

    public static String getDateStartStr(Date date) {
        return DateUtils.getDateStr(date, LINK_DISPLAY_DATE) + " 00:00:00";
    }

    public static String getDateEndStr(Date date) {
        return DateUtils.getDateStr(date, LINK_DISPLAY_DATE) + " 23:59:59";
    }

    public static Date getNowDate() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(LINK_DISPLAY_DATE);
            Date nowDate = sdf.parse(sdf.format(new Date()));
            return nowDate;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getCurrentTime() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(LINK_DISPLAY_DATE_FULL);
            Date nowDate = sdf.parse(sdf.format(new Date()));
            return nowDate;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getCurrentTime(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.add(14, timeZone.getRawOffset() - TimeZone.getDefault().getRawOffset());
        return cal.getTime();
    }

    public static String getCurrentTimeStr() {
        return DateUtils.getDateStr(new Date(), LINK_DATABASE_DATE_MSEL);
    }

    public static Date getHour(Date date) {
        SimpleDateFormat fomate = new SimpleDateFormat(LINK_DISPLAY_DATE_HOURS);
        String dateStr = fomate.format(date);
        try {
            Date hour = fomate.parse(dateStr);
            return hour;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getM(Date date) {
        SimpleDateFormat fomate = new SimpleDateFormat(LINK_DISPLAY_DATE_MINUTE);
        String dateStr = fomate.format(date);
        try {
            Date hour = fomate.parse(dateStr);
            return hour;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDateHMS(Date date) {
        return DateUtils.getDateStr(date, LINK_DISPLAY_DATE_HMS);
    }

    public static Date StringToDate(String strDate, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            Date date = sdf.parse(strDate);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date praseDateToDatePattern(Date date, String format) {
        String resultDate = DateUtils.getDateStr(date, format);
        return DateUtils.StringToDate(resultDate, format);
    }

    public static String praseStringtoStringPattern(String date, String format) {
        Date resultDate = DateUtils.StringToDate(date, format);
        return DateUtils.getDateStr(resultDate, format);
    }

    public static String praseStringtoStringPattern(String date, String inputFormat, String outputFormat) {
        Date resultDate = DateUtils.StringToDate(date, inputFormat);
        return DateUtils.getDateStr(resultDate, outputFormat);
    }

    public static boolean isToday(Date compareDate) {
        Calendar compareCalendar = Calendar.getInstance();
        compareCalendar.setTime(DateUtils.praseDateToDatePattern(compareDate, LINK_DISPLAY_DATE));
        Calendar todayCalendar = Calendar.getInstance();
        todayCalendar.setTime(DateUtils.getNowDate());
        long l = compareCalendar.getTimeInMillis() - todayCalendar.getTimeInMillis();
        int days = new Long(l / 86400000L).intValue();
        return days == 0;
    }

    public static String getShowTimeStr(String dateStr, int timeType) {
        Object output = null;
        SimpleDateFormat sdf = new SimpleDateFormat(LINK_DISPLAY_DATE_FULL);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timeType) {
            case 0: {
                output = dateStr.substring(11, 16);
                break;
            }
            case 1: {
                output = dateStr.substring(11, 16);
                break;
            }
            case 2: {
                output = dateStr.substring(5, 10);
                break;
            }
            case 9: {
                output = dateStr;
                break;
            }
            case 10: {
                output = dateStr.substring(0, 10);
                break;
            }
            case 3: {
                if (cal.get(3) == 1) {
                    output = cal.get(1) + 1 + "\u5e74\u7b2c" + cal.get(3) + "\u5468";
                    break;
                }
                output = cal.get(1) + "\u5e74\u7b2c" + cal.get(3) + "\u5468";
                break;
            }
            case 4: {
                int month = cal.get(2) + 1;
                String year = "" + cal.get(1);
                String monthStr = month < 10 ? "0" + month : "" + month;
                output = year.substring(2, year.length()) + "-" + monthStr;
                break;
            }
            case 11: {
                output = DateUtils.getDateStr(DateUtils.getFirstDayOfMonth(date), LINK_DISPLAY_DATE_FULL);
                break;
            }
            case 5: {
                output = cal.get(1) + "\u5e74\u7b2c" + (cal.get(2) / 3 + 1) + "\u5b63\u5ea6";
                break;
            }
            case 6: {
                output = "" + cal.get(1);
                break;
            }
            case 13: {
                output = "" + cal.get(1);
                break;
            }
            case 8: {
                output = DateUtils.getDateStr(DateUtils.getFirstDayOfWeek(cal.getTime()), LINK_DISPLAY_DATE);
                break;
            }
            default: {
                output = dateStr.substring(11, 16);
            }
        }
        return output;
    }

    public static String getFirstDayStr(Date date, int timeType) {
        String output = null;
        if (date == null) {
            return output;
        }
        switch (timeType) {
            case 0: 
            case 1: 
            case 2: {
                output = DateUtils.getDateStr(date, LINK_DISPLAY_DATE) + " 00:00:00";
                break;
            }
            case 3: {
                output = DateUtils.getFirstDayStrOfWeek(date) + " 00:00:00";
                break;
            }
            case 4: {
                output = DateUtils.getFirstDayStrOfMonth(date) + " 00:00:00";
                break;
            }
            case 5: {
                output = DateUtils.getFirstDayStrOfQuarter(date) + " 00:00:00";
                break;
            }
            case 6: {
                break;
            }
            case 13: {
                output = DateUtils.getFirstDayStrOfQuarter(date) + " 00:00:00";
            }
        }
        return output;
    }

    public static List<String> findAllTimesInTwoDates(String stime, String etime, Integer timeType) {
        ArrayList<String> times = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(LINK_DISPLAY_DATE_FULL);
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(stime);
            endDate = sdf.parse(etime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (timeType == 4) {
            startDate = DateUtils.getFirstDayOfMonth(startDate);
        }
        if (timeType == 3) {
            startDate = DateUtils.getFirstDayOfWeek(startDate);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (cal.getTime().before(endDate)) {
            String dateStr = sdf.format(cal.getTime());
            String timeStr = DateUtils.getShowTimeStr(dateStr, timeType);
            times.add(timeStr);
            switch (timeType) {
                case 0: {
                    cal.add(12, 1);
                    break;
                }
                case 1: {
                    cal.add(10, 1);
                    break;
                }
                case 2: 
                case 9: 
                case 10: {
                    cal.add(5, 1);
                    break;
                }
                case 3: 
                case 8: {
                    cal.add(5, 7);
                    break;
                }
                case 4: 
                case 11: {
                    cal.add(2, 1);
                    break;
                }
                case 5: {
                    cal.add(2, 3);
                    break;
                }
                case 6: 
                case 13: {
                    cal.add(1, 1);
                }
            }
        }
        return times;
    }

    public static String getFirstDayOfFewWeek(String dateStr, int num) {
        Date date = DateUtils.StringToDate(dateStr, LINK_DISPLAY_DATE);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(3, num);
        return DateUtils.getDateStr(DateUtils.getFirstDayOfWeek(calendar.getTime()), LINK_DISPLAY_DATE) + " 00:00:00";
    }

    public static String getFirstDayStrOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getDateStr(DateUtils.getFirstDayOfWeek(calendar.getTime()), LINK_DISPLAY_DATE);
    }

    public static String getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        String output = "\u7b2c" + cal.get(3) + "\u5468";
        return output;
    }

    public static Date getFirstDayOfWeek(int year, int week) {
        --week;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 0);
        calendar.set(5, 1);
        Calendar cal = (Calendar)calendar.clone();
        cal.add(5, week * 7);
        return DateUtils.getFirstDayOfWeek(cal.getTime());
    }

    public static Date getLastDayOfWeek(int year, int week) {
        --week;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 0);
        calendar.set(5, 1);
        Calendar cal = (Calendar)calendar.clone();
        cal.add(5, week * 7);
        return DateUtils.getLastDayOfWeek(cal.getTime());
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(7, calendar.getFirstDayOfWeek());
        return calendar.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(7, calendar.getFirstDayOfWeek() + 6);
        return calendar.getTime();
    }

    public static Date getLastDayOfLastWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getLastDayOfWeek(calendar.get(1), calendar.get(3) - 1);
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1);
        return DateUtils.getDateStart(calendar.getTime());
    }

    public static String getFirstDayStrOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getDateStr(DateUtils.getFirstDayOfMonth(calendar.getTime()), LINK_DISPLAY_DATE);
    }

    public static Date getFirstDayOfMonth(Integer year, Integer month) {
        Calendar calendar = Calendar.getInstance();
        if (year == null) {
            year = calendar.get(1);
        }
        if (month == null) {
            month = calendar.get(2);
        }
        calendar.set(year, month - 1, 1);
        return calendar.getTime();
    }

    public static String getFirstDayOfMonthByStr(Integer year, Integer month) {
        Object firstDay = DateUtils.getDateStr(DateUtils.getFirstDayOfMonth(year, month), LINK_DISPLAY_DATE);
        firstDay = (String)firstDay + " 00:00:00";
        return firstDay;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1);
        calendar.roll(5, -1);
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(Integer year, Integer month) {
        Calendar calendar = Calendar.getInstance();
        if (year == null) {
            year = calendar.get(1);
        }
        if (month == null) {
            month = calendar.get(2);
        }
        calendar.set(year, month - 1, 1);
        calendar.roll(5, -1);
        return calendar.getTime();
    }

    public static String getLastDayOfMonthByStr(Integer year, Integer month) {
        Object lastDay = DateUtils.getDateStr(DateUtils.getLastDayOfMonth(year, month), LINK_DISPLAY_DATE);
        lastDay = (String)lastDay + " 23:59:59";
        return lastDay;
    }

    public static Date getLastDayOfLastMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2) - 1, 1);
        calendar.roll(5, -1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfLastMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getFirstDayOfQuarter(calendar.get(1), DateUtils.getQuarterOfYear(date));
    }

    public static String getFirstDayStr4Year(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Date firstDate = DateUtils.getFirstDayOfQuarter(calendar.get(1), DateUtils.getQuarterOfYear(date));
        return DateUtils.getDateStr(firstDate, LINK_DISPLAY_DATE);
    }

    public static String getFirstDayStrOfQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Date firstDate = DateUtils.getFirstDayOfQuarter(calendar.get(1), DateUtils.getQuarterOfYear(date));
        return DateUtils.getDateStr(firstDate, LINK_DISPLAY_DATE);
    }

    public static Date getFirstDayOfQuarter(Integer year, Integer quarter) {
        Calendar calendar = Calendar.getInstance();
        Integer month = new Integer(0);
        month = quarter == 1 ? Integer.valueOf(0) : (quarter == 2 ? Integer.valueOf(3) : (quarter == 3 ? Integer.valueOf(6) : (quarter == 4 ? Integer.valueOf(9) : Integer.valueOf(calendar.get(2)))));
        return DateUtils.getFirstDayOfMonth(year, month);
    }

    public static Date getLastDayOfQuarter(Integer year, Integer quarter) {
        Calendar calendar = Calendar.getInstance();
        Integer month = new Integer(0);
        month = quarter == 1 ? Integer.valueOf(2) : (quarter == 2 ? Integer.valueOf(5) : (quarter == 3 ? Integer.valueOf(8) : (quarter == 4 ? Integer.valueOf(11) : Integer.valueOf(calendar.get(2)))));
        return DateUtils.getLastDayOfMonth(year, month);
    }

    public static Date getLastDayOfQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getLastDayOfQuarter(calendar.get(1), DateUtils.getQuarterOfYear(date));
    }

    public static Date getLastDayOfLastQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getLastDayOfLastQuarter(calendar.get(1), DateUtils.getQuarterOfYear(date));
    }

    public static Date getLastDayOfLastQuarter(Integer year, Integer quarter) {
        Calendar calendar = Calendar.getInstance();
        Integer month = new Integer(0);
        month = quarter == 1 ? Integer.valueOf(11) : (quarter == 2 ? Integer.valueOf(2) : (quarter == 3 ? Integer.valueOf(5) : (quarter == 4 ? Integer.valueOf(8) : Integer.valueOf(calendar.get(2)))));
        return DateUtils.getLastDayOfMonth(year, month);
    }

    public static int getQuarterOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) / 3 + 1;
    }

    public static Date getBeforeDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }

    public static Date getAfterDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        return date;
    }

    public static Date getBeforeWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -7);
        date = calendar.getTime();
        return date;
    }

    public static Date getBeforeMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        date = calendar.getTime();
        return date;
    }

    public static Date getBeforeByDate(Date date, int num, int calendarType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(calendarType, num);
        date = calendar.getTime();
        return date;
    }

    public static String getNextMonth(String dateStr) {
        Date date = DateUtils.StringToDate(dateStr, LINK_DISPLAY_DATE_FULL);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        date = calendar.getTime();
        return DateUtils.getDateStr(date, LINK_DISPLAY_DATE_FULL);
    }

    public static String getBeforeMonthStr(String dateStr) {
        Date date = DateUtils.StringToDate(dateStr, LINK_DISPLAY_DATE_FULL);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        date = calendar.getTime();
        return DateUtils.getDateStr(date, LINK_DISPLAY_DATE_FULL);
    }

    public static Date getFewDaysAgoOrLast(Date date, int num, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, num);
        date = calendar.getTime();
        date = DateUtils.praseDateToDatePattern(date, format);
        return date;
    }

    public static String getBeforeDayStr(String dateStr, String format) {
        Date Date2 = DateUtils.StringToDate(dateStr, format);
        Date beforeDate = DateUtils.getBeforeDay(Date2);
        return DateUtils.getDateStr(beforeDate, format);
    }

    public static String getAfterDayStr(String dateStr, String format) {
        Date Date2 = DateUtils.StringToDate(dateStr, format);
        Date beforeDate = DateUtils.getAfterDay(Date2);
        return DateUtils.getDateStr(beforeDate, format);
    }

    public static String getYesterdayStr(String format) {
        Date beforeDate = DateUtils.getBeforeDay(new Date());
        return DateUtils.getDateStr(beforeDate, format);
    }

    public static Date getgetFewMonthsAgoOrLast(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, num);
        date = calendar.getTime();
        return date;
    }

    public static Date getFewMonthsAgoOrLast(Date date, int num, int calendarMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(calendarMonth, num);
        date = calendar.getTime();
        return date;
    }

    public static int daysBetween(Date smdate, Date bdate) {
        SimpleDateFormat sdf = new SimpleDateFormat(LINK_DISPLAY_DATE);
        try {
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
            Calendar cal = Calendar.getInstance();
            cal.setTime(smdate);
            long time1 = cal.getTimeInMillis();
            cal.setTime(bdate);
            long time2 = cal.getTimeInMillis();
            long between_days = (time2 - time1) / 86400000L;
            return Integer.parseInt(String.valueOf(between_days));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static Date timestampToDate(Timestamp tt) {
        return new Date(tt.getTime());
    }

    public static Date getPreOrAftDate(Date date, int timeType, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        switch (timeType) {
            case 1: {
                calendar.add(1, num);
                break;
            }
            case 2: {
                calendar.add(2, num);
                break;
            }
            case 3: {
                calendar.add(3, num);
                break;
            }
            case 6: {
                calendar.add(6, num);
                break;
            }
            case 10: {
                calendar.add(10, num);
                break;
            }
            case 12: {
                calendar.add(12, num);
                break;
            }
            case 13: {
                calendar.add(13, num);
            }
        }
        return calendar.getTime();
    }

    public static Date getLastRunTime(Date startTime, Date endTime, int intervalSeconds) {
        Date tempDate = startTime;
        while (endTime.after(tempDate)) {
            tempDate = DateUtils.getPreOrAftDate(tempDate, 13, intervalSeconds);
        }
        return DateUtils.getPreOrAftDate(tempDate, 13, 0 - intervalSeconds);
    }

    public static boolean isDatePartEqual(Date date1, Date date2, String formatStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        String s1 = sdf.format(date1);
        String s2 = sdf.format(date2);
        return s1.equals(s2);
    }

    public static Date getDateByHour(Date date, String timeStr) {
        String dateStr = DateUtils.getDateStr(date, LINK_DISPLAY_DATE);
        return DateUtils.StringToDate(dateStr + " " + timeStr, LINK_DISPLAY_DATE_MINUTE);
    }

    public static long getTimeDif(Date stime, Date etime) {
        return stime.getTime() - etime.getTime();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(DateUtils.getLastDayOfMonth(new Date()));
    }

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(dBegin);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(calBegin.getTime());
        }
        return lDate;
    }

    public static String secondsConvertToDateStr(int seconds) {
        StringBuffer str = new StringBuffer();
        if (seconds > 0) {
            int day = seconds / 86400;
            int hour = (seconds - 86400 * day) / 3600;
            int minute = (seconds - 86400 * day - 3600 * hour) / 60;
            int second = seconds - 86400 * day - 3600 * hour - 60 * minute;
            if (day > 0) {
                str.append(day).append("\u5929");
            }
            if (hour > 0) {
                str.append(hour).append("\u5c0f\u65f6");
            }
            if (minute > 0) {
                str.append(minute).append("\u5206\u949f");
            }
            if (second > 0) {
                str.append(second).append("\u79d2");
            }
        } else {
            str.append("0\u79d2");
        }
        return str.toString();
    }

    public static Integer getWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Integer week_index = cal.get(7) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        return week_index;
    }

    public static Date min(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return null;
        }
        if (date1.before(date2)) {
            return date1;
        }
        return date2;
    }

    public static Date max(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return null;
        }
        if (date1.before(date2)) {
            return date2;
        }
        return date1;
    }

    public static LocalDate dateToLocalDate(Date date) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime;
    }

    public static String toStringDateTime(Date date, String type) {
        SimpleDateFormat format = new SimpleDateFormat(type);
        String formateDate = format.format(date);
        return formateDate;
    }

    public static Date toLocalDateTimeToDate(LocalDateTime localDateTime) {
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        Instant instant = zonedDateTime.toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static List<String> getBetweenDates(String minDate, String maxDate) throws ParseException {
        ArrayList<String> listDate = new ArrayList<String>();
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(LINK_DISPLAY_DATE);
        Date startDate = df.parse(minDate);
        startCalendar.setTime(startDate);
        Date endDate = df.parse(maxDate);
        endCalendar.setTime(endDate);
        listDate.add(df.format(startCalendar.getTime()));
        while (true) {
            startCalendar.add(5, 1);
            if (startCalendar.getTimeInMillis() > endCalendar.getTimeInMillis()) break;
            listDate.add(df.format(startCalendar.getTime()));
        }
        return listDate;
    }

    public static List<Date> getBetweenMinute(Date startDate, Date endDate) {
        ArrayList<Date> listDate = new ArrayList<Date>();
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        endCalendar.setTime(endDate);
        listDate.add(startCalendar.getTime());
        while (true) {
            startCalendar.add(12, 1);
            if (startCalendar.getTimeInMillis() > endCalendar.getTimeInMillis()) break;
            listDate.add(startCalendar.getTime());
        }
        return listDate;
    }
}

