/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger log = LoggerFactory.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Object params, Integer timeOut) throws Exception {
        if (timeOut == null) {
            timeOut = 10000;
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeOut.intValue()).setConnectTimeout(timeOut.intValue()).build();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(JSON.toJSONString((Object)params), charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == 200) {
                HttpEntity responseEntity = response.getEntity();
                String string = EntityUtils.toString((HttpEntity)responseEntity, (String)charSet);
                return string;
            }
            log.error("\u8bf7\u6c42\u8fd4\u56de:" + state + "(" + url + ")");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostWithExtraHeaders(String url, Map<String, String> extraHeaders, Map<String, Object> params, Integer timeOut) throws Exception {
        if (timeOut == null) {
            timeOut = 10000;
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeOut.intValue()).setConnectTimeout(timeOut.intValue()).build();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Content-Type", "application/json");
        if (extraHeaders != null) {
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(JSON.toJSONString(params), charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == 200) {
                HttpEntity responseEntity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)responseEntity, (String)charSet);
                log.info("request url:" + url + "; response:" + result);
                String string = result;
                return string;
            }
            log.error("\u8bf7\u6c42\u8fd4\u56de:" + state + "(" + url + ")");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String doGetWithExtraHeaders(String url, Map<String, String> extraHeaders, Map<String, Object> params, Integer timeOut) throws Exception {
        CloseableHttpClient httpclient;
        block23: {
            int state;
            CloseableHttpResponse closeableHttpResponse;
            block21: {
                String string;
                block22: {
                    if (timeOut == null) {
                        timeOut = 10000;
                    }
                    RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeOut.intValue()).setConnectTimeout(timeOut.intValue()).build();
                    httpclient = HttpClients.createDefault();
                    if (params != null) {
                        Iterator<Map.Entry<String, Object>> entries = params.entrySet().iterator();
                        String connectionStr = "?";
                        while (entries.hasNext()) {
                            Map.Entry<String, Object> entry = entries.next();
                            url = (String)url + connectionStr + entry.getKey() + "=" + String.valueOf(entry.getValue());
                            connectionStr = "&";
                        }
                    }
                    HttpGet httpGet = new HttpGet((String)url);
                    httpGet.setConfig(requestConfig);
                    if (extraHeaders != null) {
                        for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                            httpGet.setHeader(entry.getKey(), entry.getValue());
                        }
                    }
                    String charSet = "UTF-8";
                    Object var8_11 = null;
                    try {
                        closeableHttpResponse = httpclient.execute((HttpUriRequest)httpGet);
                        StatusLine status = closeableHttpResponse.getStatusLine();
                        state = status.getStatusCode();
                        if (state != 200) break block21;
                        HttpEntity responseEntity = closeableHttpResponse.getEntity();
                        String result = EntityUtils.toString((HttpEntity)responseEntity, (String)charSet);
                        log.info("request url:" + (String)url + "; response:" + result);
                        string = result;
                        if (closeableHttpResponse == null) break block22;
                    }
                    catch (Throwable throwable) {
                        void var8_13;
                        if (var8_13 != null) {
                            try {
                                var8_13.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            httpclient.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        closeableHttpResponse.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    httpclient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return string;
            }
            log.error("\u8bf7\u6c42\u8fd4\u56de:" + state + "(" + (String)url + ")");
            if (closeableHttpResponse == null) break block23;
            try {
                closeableHttpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            httpclient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGetToOtherServer(String url) {
        String result = "";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        try {
            httpGet.setHeader("Content-type", "application/json; charset=utf-8");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("send url = " + url);
            log.error("sendGetToOtherServer", (Throwable)e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return result;
    }

    public static String sendPostToOtherServer(String url, Map<String, Object> params) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception var10) {
            log.error("sendPostToOtherServer", (Throwable)var10);
        }
        return result;
    }

    public static String sendPostToTokenServer(String url, Map<String, Object> params, String token) throws Exception {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpPost.setHeader("Ovo-Authorization", token);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception var10) {
            log.error("sendPostToOtherServer", (Throwable)var10);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendJsonAndTokenToOtherServer(String url, Object data, String token) {
        String result = "";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        try {
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Ovo-Authorization", token);
            httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)data), Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendJsonToOtherServer", (Throwable)e);
        }
        finally {
            httpPost.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendJsonToOtherServer(String url, Object data) {
        String result = "";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        try {
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)data), Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendJsonToOtherServer", (Throwable)e);
        }
        finally {
            httpPost.releaseConnection();
        }
        return result;
    }
}

